/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler;

import de.rub.nds.protocol.exception.CryptoException;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.constants.Tls13KeySetType;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.ProtocolMessageHandler;
import de.rub.nds.tlsattacker.core.protocol.message.ChangeCipherSpecMessage;
import de.rub.nds.tlsattacker.core.record.cipher.RecordCipher;
import de.rub.nds.tlsattacker.core.record.cipher.RecordCipherFactory;
import de.rub.nds.tlsattacker.core.record.cipher.cryptohelper.KeyDerivator;
import de.rub.nds.tlsattacker.core.record.cipher.cryptohelper.KeySet;
import java.security.NoSuchAlgorithmException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChangeCipherSpecHandler
extends ProtocolMessageHandler<ChangeCipherSpecMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public ChangeCipherSpecHandler(TlsContext tlsContext) {
        super(tlsContext);
    }

    @Override
    public void adjustContext(ChangeCipherSpecMessage message) {
        if (this.tlsContext.getTalkingConnectionEndType() != this.tlsContext.getChooser().getConnectionEndType() && this.tlsContext.getChooser().getSelectedProtocolVersion() != ProtocolVersion.TLS13) {
            LOGGER.debug("Adjusting decrypting cipher for " + String.valueOf(this.tlsContext.getTalkingConnectionEndType()));
            this.tlsContext.getRecordLayer().updateDecryptionCipher(this.getRecordCipher(false));
            this.tlsContext.getRecordLayer().updateDecompressor();
        }
    }

    @Override
    public void adjustContextAfterSerialize(ChangeCipherSpecMessage message) {
        if (!this.tlsContext.getChooser().getSelectedProtocolVersion().isTLS13()) {
            LOGGER.debug("Adjusting encrypting cipher for " + String.valueOf(this.tlsContext.getTalkingConnectionEndType()));
            this.tlsContext.getRecordLayer().updateEncryptionCipher(this.getRecordCipher(true));
            this.tlsContext.getRecordLayer().updateCompressor();
        }
    }

    private RecordCipher getRecordCipher(boolean isForEncryption) {
        try {
            KeySet keySet = KeyDerivator.generateKeySet(this.tlsContext, this.tlsContext.getChooser().getSelectedProtocolVersion(), Tls13KeySetType.NONE);
            return RecordCipherFactory.getRecordCipher(this.tlsContext, keySet, isForEncryption);
        }
        catch (CryptoException | NoSuchAlgorithmException ex) {
            throw new UnsupportedOperationException("The specified Algorithm is not supported", ex);
        }
    }
}

