/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler;

import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.handler.CoreClientHelloHandler;
import de.rub.nds.tlsattacker.core.protocol.message.ClientHelloMessage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientHelloHandler
extends CoreClientHelloHandler<ClientHelloMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public ClientHelloHandler(TlsContext tlsContext) {
        super(tlsContext);
    }

    @Override
    public void adjustContext(ClientHelloMessage message) {
        this.tlsContext.setLastClientHello((byte[])message.getCompleteResultingMessage().getValue());
        this.tlsContext.setInnerClientHello(message);
        super.adjustContext(message);
        LOGGER.debug("Set InnerClient in Context to {}", (Object)message.getCompleteResultingMessage());
    }

    @Override
    public void adjustContextAfterSerialize(ClientHelloMessage message) {
        super.adjustContextAfterSerialize(message);
        if (this.tlsContext.getInnerClientHello() == null) {
            this.tlsContext.setLastClientHello((byte[])message.getCompleteResultingMessage().getValue());
        }
    }
}

