/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler;

import de.rub.nds.protocol.exception.CryptoException;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.handler.HandshakeMessageHandler;
import de.rub.nds.tlsattacker.core.protocol.message.ClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.record.cipher.cryptohelper.KeyDerivator;
import de.rub.nds.tlsattacker.core.state.session.IdSession;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ClientKeyExchangeHandler<Message extends ClientKeyExchangeMessage>
extends HandshakeMessageHandler<Message> {
    private static final Logger LOGGER = LogManager.getLogger();

    public ClientKeyExchangeHandler(TlsContext tlsContext) {
        super(tlsContext);
    }

    public void adjustPremasterSecret(Message message) {
        if (((ClientKeyExchangeMessage)message).getComputations().getPremasterSecret() != null) {
            byte[] premasterSecret = (byte[])((ClientKeyExchangeMessage)message).getComputations().getPremasterSecret().getValue();
            this.tlsContext.setPreMasterSecret(premasterSecret);
            LOGGER.debug("Set PremasterSecret in Context to {}", (Object)premasterSecret);
        } else {
            LOGGER.debug("Did not set in Context PremasterSecret");
        }
    }

    public void adjustMasterSecret(Message message) {
        byte[] masterSecret;
        try {
            masterSecret = KeyDerivator.calculateMasterSecret(this.tlsContext, (byte[])((ClientKeyExchangeMessage)message).getComputations().getClientServerRandom().getValue());
        }
        catch (CryptoException ex) {
            throw new UnsupportedOperationException("Could not calculate masterSecret", ex);
        }
        this.tlsContext.setMasterSecret(masterSecret);
        LOGGER.debug("Set MasterSecret in Context to {}", (Object)masterSecret);
    }

    protected void spawnNewSession() {
        if (this.tlsContext.getChooser().getServerSessionId().length != 0) {
            IdSession session = new IdSession(this.tlsContext.getChooser().getMasterSecret(), this.tlsContext.getChooser().getServerSessionId());
            this.tlsContext.addNewSession(session);
            LOGGER.debug("Spawning new resumable Session");
        }
    }
}

