/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler;

import de.rub.nds.tlsattacker.core.constants.ExtensionType;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.layer.data.Handler;
import de.rub.nds.tlsattacker.core.protocol.handler.HandshakeMessageHandler;
import de.rub.nds.tlsattacker.core.protocol.message.EncryptedExtensionsMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ExtensionMessage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EncryptedExtensionsHandler
extends HandshakeMessageHandler<EncryptedExtensionsMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public EncryptedExtensionsHandler(TlsContext tlsContext) {
        super(tlsContext);
    }

    @Override
    public void adjustContext(EncryptedExtensionsMessage message) {
        if (message.getExtensions() != null) {
            LOGGER.debug("Adjusting for EncryptedExtensions:");
            for (ExtensionMessage extension : message.getExtensions()) {
                LOGGER.debug("Adjusting " + message.toCompactString());
                Handler handler = extension.getHandler(this.tlsContext.getContext());
                handler.adjustContext(extension);
            }
            this.warnOnConflictingExtensions();
        }
    }

    private void warnOnConflictingExtensions() {
        if (this.tlsContext.getTalkingConnectionEndType() == this.tlsContext.getChooser().getMyConnectionPeer() && this.tlsContext.isExtensionNegotiated(ExtensionType.MAX_FRAGMENT_LENGTH) && this.tlsContext.isExtensionNegotiated(ExtensionType.RECORD_SIZE_LIMIT)) {
            LOGGER.warn("Server sent max_fragment_length AND record_size_limit extensions");
        }
    }
}

