/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler;

import de.rub.nds.protocol.exception.CryptoException;
import de.rub.nds.tlsattacker.core.constants.AlgorithmResolver;
import de.rub.nds.tlsattacker.core.constants.DigestAlgorithm;
import de.rub.nds.tlsattacker.core.constants.HKDFAlgorithm;
import de.rub.nds.tlsattacker.core.constants.Tls13KeySetType;
import de.rub.nds.tlsattacker.core.crypto.HKDFunction;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.handler.HandshakeMessageHandler;
import de.rub.nds.tlsattacker.core.protocol.message.NewSessionTicketMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.psk.PskSet;
import de.rub.nds.tlsattacker.core.state.session.TicketSession;
import java.security.NoSuchAlgorithmException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedList;
import java.util.List;
import javax.crypto.Mac;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NewSessionTicketHandler
extends HandshakeMessageHandler<NewSessionTicketMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public NewSessionTicketHandler(TlsContext tlsContext) {
        super(tlsContext);
    }

    @Override
    public void adjustContext(NewSessionTicketMessage message) {
        if (this.tlsContext.getChooser().getSelectedProtocolVersion().is13()) {
            this.adjustPskSets(message);
        } else {
            byte[] ticket = (byte[])message.getTicket().getIdentity().getValue();
            LOGGER.debug("Adding Session for Ticket resumption using dummy SessionID");
            TicketSession session = new TicketSession(this.tlsContext.getChooser().getMasterSecret(), ticket);
            this.tlsContext.addNewSession(session);
        }
    }

    private void adjustPskSets(NewSessionTicketMessage message) {
        LOGGER.debug("Adjusting PSK-Sets");
        List<PskSet> pskSets = this.tlsContext.getPskSets();
        if (pskSets == null) {
            pskSets = new LinkedList<PskSet>();
        }
        PskSet pskSet = new PskSet();
        pskSet.setCipherSuite(this.tlsContext.getChooser().getSelectedCipherSuite());
        if (message.getTicket().getTicketAgeAdd() != null) {
            pskSet.setTicketAgeAdd((byte[])message.getTicket().getTicketAgeAdd().getValue());
        } else {
            LOGGER.warn("No TicketAge specified in SessionTicket");
        }
        if (message.getTicket().getIdentity() != null) {
            pskSet.setPreSharedKeyIdentity((byte[])message.getTicket().getIdentity().getValue());
        } else {
            LOGGER.warn("No Identity in ticket. Using new byte[0] instead");
            pskSet.setPreSharedKeyIdentity(new byte[0]);
        }
        pskSet.setTicketAge(this.getTicketAge());
        if (message.getTicket().getTicketNonce() != null) {
            pskSet.setTicketNonce((byte[])message.getTicket().getTicketNonce().getValue());
        } else {
            LOGGER.warn("No nonce in ticket. Using new byte[0] instead");
            pskSet.setTicketNonce(new byte[0]);
        }
        if (this.tlsContext.getActiveClientKeySetType() == Tls13KeySetType.APPLICATION_TRAFFIC_SECRETS) {
            pskSet.setPreSharedKey(this.derivePsk(pskSet));
        }
        LOGGER.debug("Adding PSK Set");
        pskSets.add(pskSet);
        this.tlsContext.setPskSets(pskSets);
    }

    private String getTicketAge() {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
        LocalDateTime ticketDate = LocalDateTime.now();
        return ticketDate.format(dateTimeFormatter);
    }

    protected byte[] derivePsk(PskSet pskSet) {
        try {
            LOGGER.debug("Deriving PSK from current session");
            HKDFAlgorithm hkdfAlgorithm = AlgorithmResolver.getHKDFAlgorithm(this.tlsContext.getChooser().getSelectedCipherSuite());
            DigestAlgorithm digestAlgo = AlgorithmResolver.getDigestAlgorithm(this.tlsContext.getChooser().getSelectedProtocolVersion(), this.tlsContext.getChooser().getSelectedCipherSuite());
            int macLength = Mac.getInstance(hkdfAlgorithm.getMacAlgorithm().getJavaName()).getMacLength();
            byte[] resumptionMasterSecret = HKDFunction.deriveSecret(hkdfAlgorithm, digestAlgo.getJavaName(), this.tlsContext.getChooser().getMasterSecret(), "res master", this.tlsContext.getDigest().getRawBytes(), this.tlsContext.getChooser().getSelectedProtocolVersion());
            this.tlsContext.setResumptionMasterSecret(resumptionMasterSecret);
            LOGGER.debug("Derived ResumptionMasterSecret: {}", (Object)resumptionMasterSecret);
            LOGGER.debug("Handshake Transcript Raw Bytes: {}", (Object)this.tlsContext.getDigest().getRawBytes());
            byte[] psk = HKDFunction.expandLabel(hkdfAlgorithm, resumptionMasterSecret, "resumption", pskSet.getTicketNonce(), macLength, this.tlsContext.getChooser().getSelectedProtocolVersion());
            LOGGER.debug("New derived pre-shared-key: {}", (Object)psk);
            return psk;
        }
        catch (CryptoException | NoSuchAlgorithmException ex) {
            LOGGER.error("DigestAlgorithm for psk derivation unknown");
            return new byte[0];
        }
    }
}

