/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler;

import de.rub.nds.protocol.crypto.ec.PointFormatter;
import de.rub.nds.tlsattacker.core.constants.NamedGroup;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.handler.ServerKeyExchangeHandler;
import de.rub.nds.tlsattacker.core.protocol.message.PWDServerKeyExchangeMessage;
import java.math.BigInteger;

public class PWDServerKeyExchangeHandler
extends ServerKeyExchangeHandler<PWDServerKeyExchangeMessage> {
    public PWDServerKeyExchangeHandler(TlsContext tlsContext) {
        super(tlsContext);
    }

    @Override
    public void adjustContext(PWDServerKeyExchangeMessage message) {
        this.tlsContext.setSelectedGroup(NamedGroup.getNamedGroup((byte[])message.getNamedGroup().getValue()));
        this.tlsContext.setServerPWDSalt((byte[])message.getSalt().getValue());
        this.tlsContext.setServerPWDElement(PointFormatter.formatFromByteArray(this.tlsContext.getChooser().getSelectedNamedGroup().getGroupParameters(), (byte[])((byte[])message.getElement().getValue())));
        this.tlsContext.setServerPWDScalar(new BigInteger(1, (byte[])message.getScalar().getValue()));
        if (message.getKeyExchangeComputations() != null) {
            this.tlsContext.setPwdPasswordElement(message.getKeyExchangeComputations().getPasswordElement());
            this.tlsContext.setServerPWDPrivate(message.getKeyExchangeComputations().getPrivateKeyScalar());
        }
    }
}

