/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler;

import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.handler.ServerKeyExchangeHandler;
import de.rub.nds.tlsattacker.core.protocol.message.RSAServerKeyExchangeMessage;
import java.math.BigInteger;

public class RSAServerKeyExchangeHandler
extends ServerKeyExchangeHandler<RSAServerKeyExchangeMessage> {
    public RSAServerKeyExchangeHandler(TlsContext tlsContext) {
        super(tlsContext);
    }

    @Override
    public void adjustContext(RSAServerKeyExchangeMessage message) {
        this.tlsContext.setServerEphemeralRsaExportModulus(new BigInteger(1, (byte[])message.getModulus().getValue()));
        this.tlsContext.setServerEphemeralRsaExportPublicKey(new BigInteger(1, (byte[])message.getPublicKey().getValue()));
        this.adjustSelectedSignatureAndHashAlgorithm(message);
        if (message.getKeyExchangeComputations() != null && message.getKeyExchangeComputations().getPrivateKey() != null) {
            this.tlsContext.setServerEphemeralRsaExportPrivateKey((BigInteger)message.getKeyExchangeComputations().getPrivateKey().getValue());
        }
    }
}

