/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler;

import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.handler.SSL2MessageHandler;
import de.rub.nds.tlsattacker.core.protocol.message.SSL2ClientMasterKeyMessage;

public class SSL2ClientMasterKeyHandler
extends SSL2MessageHandler<SSL2ClientMasterKeyMessage> {
    public SSL2ClientMasterKeyHandler(TlsContext tlsContext) {
        super(tlsContext);
    }

    @Override
    public void adjustContext(SSL2ClientMasterKeyMessage message) {
        byte[] premasterSecret = (byte[])message.getComputations().getPremasterSecret().getValue();
        this.tlsContext.setPreMasterSecret(premasterSecret);
        this.tlsContext.setClearKey((byte[])message.getClearKeyData().getValue());
        if (this.tlsContext.getChooser().getSSL2CipherSuite().getBlockSize() != 0) {
            this.tlsContext.setSSL2Iv((byte[])message.getKeyArgData().getValue());
        }
    }
}

