/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler;

import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.layer.data.Handler;
import de.rub.nds.tlsattacker.core.protocol.message.SSL2Message;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class SSL2MessageHandler<MessageT extends SSL2Message>
extends Handler<MessageT> {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final TlsContext tlsContext;

    public SSL2MessageHandler(TlsContext tlsContext) {
        this.tlsContext = tlsContext;
    }

    public void updateDigest(MessageT message, boolean goingToBeSent) {
        this.tlsContext.getDigest().append((byte[])((SSL2Message)message).getCompleteResultingMessage().getValue());
        LOGGER.debug("Included in digest: {}", (Object)message.toCompactString());
    }

    public void adjustContextAfterSerialize(MessageT message) {
    }

    public void adjustContextBeforeParse(MessageT message) {
    }

    public void adjustContextAfterParse(MessageT message) {
    }

    public void adjustContextAfterPrepare(MessageT message) {
    }

    public void adjustContextBeforePrepare(MessageT message) {
    }
}

