/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler;

import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.protocol.crypto.CyclicGroup;
import de.rub.nds.protocol.crypto.ec.EllipticCurve;
import de.rub.nds.protocol.crypto.ec.Point;
import de.rub.nds.protocol.crypto.ec.PointFormatter;
import de.rub.nds.protocol.exception.AdjustmentException;
import de.rub.nds.protocol.exception.CryptoException;
import de.rub.nds.tlsattacker.core.constants.AlgorithmResolver;
import de.rub.nds.tlsattacker.core.constants.CipherSuite;
import de.rub.nds.tlsattacker.core.constants.CompressionMethod;
import de.rub.nds.tlsattacker.core.constants.DigestAlgorithm;
import de.rub.nds.tlsattacker.core.constants.ExtensionType;
import de.rub.nds.tlsattacker.core.constants.HKDFAlgorithm;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.constants.Tls13KeySetType;
import de.rub.nds.tlsattacker.core.crypto.HKDFunction;
import de.rub.nds.tlsattacker.core.crypto.KeyShareCalculator;
import de.rub.nds.tlsattacker.core.crypto.MessageDigestCollector;
import de.rub.nds.tlsattacker.core.crypto.hpke.HpkeUtil;
import de.rub.nds.tlsattacker.core.layer.constant.StackConfiguration;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.handler.ClientHelloHandler;
import de.rub.nds.tlsattacker.core.protocol.handler.HandshakeMessageHandler;
import de.rub.nds.tlsattacker.core.protocol.message.ClientHelloMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ServerHelloMessage;
import de.rub.nds.tlsattacker.core.protocol.message.computations.PWDComputations;
import de.rub.nds.tlsattacker.core.protocol.message.extension.EncryptedClientHelloExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.keyshare.DragonFlyKeyShareEntry;
import de.rub.nds.tlsattacker.core.protocol.message.extension.keyshare.KeyShareStoreEntry;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.keyshare.DragonFlyKeyShareEntryParser;
import de.rub.nds.tlsattacker.core.quic.packet.QuicPacketCryptoComputations;
import de.rub.nds.tlsattacker.core.record.cipher.RecordCipherFactory;
import de.rub.nds.tlsattacker.core.record.cipher.cryptohelper.KeyDerivator;
import de.rub.nds.tlsattacker.core.record.cipher.cryptohelper.KeySet;
import de.rub.nds.tlsattacker.core.state.session.Session;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

public class ServerHelloHandler
extends HandshakeMessageHandler<ServerHelloMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String echLabel = "ech accept confirmation";
    private static final String echHrrLabel = "hrr accept confirmation";

    public ServerHelloHandler(TlsContext tlsContext) {
        super(tlsContext);
    }

    @Override
    public void adjustContext(ServerHelloMessage message) {
        this.adjustSelectedCipherSuite(message);
        if (this.tlsContext.getConfig().isAddEncryptedClientHelloExtension().booleanValue() && this.tlsContext.getTransportHandler().getConnectionEndType() == ConnectionEndType.CLIENT) {
            this.determineEncryptedClientHelloSupport(message, message.hasTls13HelloRetryRequestRandom());
        } else if (!this.tlsContext.getConfig().isAddEncryptedClientHelloExtension().booleanValue()) {
            LOGGER.debug("Not determining Server ECH support because ECH disabled");
        } else if (this.tlsContext.getTransportHandler().getConnectionEndType() != ConnectionEndType.CLIENT) {
            LOGGER.debug("Not determining Server ECH support because we are Server");
        }
        this.adjustSelectedProtocolVersion(message);
        this.adjustSelectedCompression(message);
        this.adjustSelectedSessionID(message);
        this.adjustServerRandom(message);
        this.adjustExtensions(message);
        this.warnOnConflictingExtensions();
        if (!message.hasTls13HelloRetryRequestRandom().booleanValue()) {
            if (this.tlsContext.getChooser().getSelectedProtocolVersion().is13()) {
                KeyShareStoreEntry keyShareStoreEntry = this.adjustKeyShareStoreEntry();
                this.adjustHandshakeTrafficSecrets(keyShareStoreEntry);
                if (this.tlsContext.getTalkingConnectionEndType() != this.tlsContext.getChooser().getConnectionEndType()) {
                    this.setServerRecordCipher();
                    this.precalculateHandshakeKeysClient();
                }
                if (this.tlsContext.getConfig().getDefaultLayerConfiguration() == StackConfiguration.QUIC) {
                    try {
                        QuicPacketCryptoComputations.calculateHandshakeSecrets(this.tlsContext.getContext());
                    }
                    catch (CryptoException | NoSuchAlgorithmException | NoSuchPaddingException e) {
                        LOGGER.error("Could not initialize handshake secrets: ", e);
                    }
                }
            }
            this.adjustPRF(message);
            if (this.tlsContext.hasSession(this.tlsContext.getChooser().getServerSessionId())) {
                LOGGER.info("Resuming Session");
                LOGGER.debug("Loading MasterSecret");
                Session session = this.tlsContext.getIdSession(this.tlsContext.getChooser().getServerSessionId());
                this.tlsContext.setMasterSecret(session.getMasterSecret());
            }
        } else {
            this.adjustHelloRetryDigest(message);
        }
    }

    private void adjustSelectedCipherSuite(ServerHelloMessage message) {
        CipherSuite suite = null;
        if (message.getSelectedCipherSuite() != null) {
            suite = CipherSuite.getCipherSuite((byte[])message.getSelectedCipherSuite().getValue());
        }
        if (suite != null) {
            this.tlsContext.setSelectedCipherSuite(suite);
            LOGGER.debug("Set SelectedCipherSuite in Context to {}", (Object)suite.name());
        } else {
            LOGGER.warn("Unknown CipherSuite, did not adjust Context");
        }
    }

    private void adjustServerRandom(ServerHelloMessage message) {
        this.tlsContext.setServerRandom((byte[])message.getRandom().getValue());
        LOGGER.debug("Set ServerRandom in Context to {}", (Object)this.tlsContext.getServerRandom());
    }

    private void adjustSelectedCompression(ServerHelloMessage message) {
        CompressionMethod method = null;
        if (message.getSelectedCompressionMethod() != null) {
            method = CompressionMethod.getCompressionMethod((Byte)message.getSelectedCompressionMethod().getValue());
        }
        if (method != null) {
            this.tlsContext.setSelectedCompressionMethod(method);
            LOGGER.debug("Set SelectedCompressionMethod in Context to {}", (Object)method.name());
        } else {
            LOGGER.warn("Not adjusting CompressionMethod - Method is null!");
        }
    }

    private void adjustSelectedSessionID(ServerHelloMessage message) {
        byte[] sessionID = (byte[])message.getSessionId().getValue();
        this.tlsContext.setServerSessionId(sessionID);
        LOGGER.debug("Set SessionID in Context to {}", (Object)sessionID);
    }

    private void adjustSelectedProtocolVersion(ServerHelloMessage message) {
        ProtocolVersion version = null;
        if (message.getProtocolVersion() != null) {
            version = ProtocolVersion.getProtocolVersion((byte[])message.getProtocolVersion().getValue());
        }
        if (version != null) {
            this.tlsContext.setSelectedProtocolVersion(version);
            LOGGER.debug("Set SelectedProtocolVersion in Context to {}", (Object)version.name());
        } else {
            LOGGER.warn("Did not Adjust ProtocolVersion since version is undefined {}", message.getProtocolVersion().getValue());
        }
    }

    private void adjustPRF(ServerHelloMessage message) {
        Chooser chooser = this.tlsContext.getChooser();
        if (!chooser.getSelectedProtocolVersion().isSSL()) {
            this.tlsContext.setPrfAlgorithm(AlgorithmResolver.getPRFAlgorithm(chooser.getSelectedProtocolVersion(), chooser.getSelectedCipherSuite()));
        }
    }

    private void setServerRecordCipher() {
        this.tlsContext.setActiveServerKeySetType(Tls13KeySetType.HANDSHAKE_TRAFFIC_SECRETS);
        LOGGER.debug("Setting cipher for server to use handshake secrets");
        KeySet serverKeySet = this.getTls13KeySet(this.tlsContext, this.tlsContext.getActiveServerKeySetType());
        if (this.tlsContext.getRecordLayer() != null) {
            if (this.tlsContext.getChooser().getConnectionEndType() == ConnectionEndType.CLIENT) {
                if (this.tlsContext.getChooser().getSelectedProtocolVersion().isDTLS13() && this.tlsContext.getRecordLayer().getDecryptor().isEpochZero()) {
                    this.tlsContext.getRecordLayer().updateDecryptionCipher(null);
                    this.tlsContext.getRecordLayer().updateEncryptionCipher(null);
                }
                this.tlsContext.getRecordLayer().updateDecryptionCipher(RecordCipherFactory.getRecordCipher(this.tlsContext, serverKeySet, false));
            } else {
                if (this.tlsContext.getChooser().getSelectedProtocolVersion().isDTLS13() && this.tlsContext.getRecordLayer().getEncryptor().isEpochZero()) {
                    this.tlsContext.getRecordLayer().updateDecryptionCipher(null);
                    this.tlsContext.getRecordLayer().updateEncryptionCipher(null);
                }
                this.tlsContext.getRecordLayer().updateEncryptionCipher(RecordCipherFactory.getRecordCipher(this.tlsContext, serverKeySet, true));
            }
        }
    }

    private KeySet getTls13KeySet(TlsContext tlsContext, Tls13KeySetType keySetType) {
        try {
            LOGGER.debug("Generating new KeySet");
            return KeyDerivator.generateKeySet(tlsContext, this.tlsContext.getChooser().getSelectedProtocolVersion(), keySetType);
        }
        catch (CryptoException | NoSuchAlgorithmException ex) {
            throw new UnsupportedOperationException("The specified Algorithm is not supported", ex);
        }
    }

    @Override
    public void adjustContextAfterSerialize(ServerHelloMessage message) {
        if (this.tlsContext.getChooser().getSelectedProtocolVersion().is13() && !message.hasTls13HelloRetryRequestRandom().booleanValue()) {
            this.setServerRecordCipher();
        }
    }

    private void adjustHandshakeTrafficSecrets(KeyShareStoreEntry keyShareStoreEntry) {
        HKDFAlgorithm hkdfAlgorithm = AlgorithmResolver.getHKDFAlgorithm(this.tlsContext.getChooser().getSelectedCipherSuite());
        DigestAlgorithm digestAlgo = AlgorithmResolver.getDigestAlgorithm(this.tlsContext.getChooser().getSelectedProtocolVersion(), this.tlsContext.getChooser().getSelectedCipherSuite());
        try {
            int macLength = hkdfAlgorithm.getMacAlgorithm().getJavaName().equals("HmacSM3") ? 32 : Mac.getInstance(hkdfAlgorithm.getMacAlgorithm().getJavaName()).getMacLength();
            byte[] psk = this.tlsContext.getConfig().isUsePsk() != false || this.tlsContext.getPsk() != null ? this.tlsContext.getChooser().getPsk() : new byte[macLength];
            byte[] earlySecret = HKDFunction.extract(hkdfAlgorithm, new byte[0], psk);
            byte[] saltHandshakeSecret = HKDFunction.deriveSecret(hkdfAlgorithm, digestAlgo.getJavaName(), earlySecret, "derived", new byte[0], this.tlsContext.getChooser().getSelectedProtocolVersion());
            byte[] sharedSecret = new byte[]{};
            if (keyShareStoreEntry != null) {
                BigInteger privateKey = this.tlsContext.getConfig().getDefaultKeySharePrivateKey(keyShareStoreEntry.getGroup());
                if (this.tlsContext.getChooser().getSelectedCipherSuite().isPWD()) {
                    sharedSecret = this.computeSharedPWDSecret(keyShareStoreEntry);
                } else {
                    sharedSecret = KeyShareCalculator.computeSharedSecret(keyShareStoreEntry.getGroup(), privateKey, keyShareStoreEntry.getPublicKey());
                    if (this.tlsContext.getConfig().getDefaultPreMasterSecret().length > 0) {
                        LOGGER.debug("Using specified PMS instead of computed PMS");
                        sharedSecret = this.tlsContext.getConfig().getDefaultPreMasterSecret();
                    }
                }
            }
            byte[] handshakeSecret = HKDFunction.extract(hkdfAlgorithm, saltHandshakeSecret, sharedSecret);
            this.tlsContext.setHandshakeSecret(handshakeSecret);
            LOGGER.debug("Set handshakeSecret in Context to {}", (Object)handshakeSecret);
            byte[] clientHandshakeTrafficSecret = HKDFunction.deriveSecret(hkdfAlgorithm, digestAlgo.getJavaName(), handshakeSecret, "c hs traffic", this.tlsContext.getDigest().getRawBytes(), this.tlsContext.getChooser().getSelectedProtocolVersion());
            this.tlsContext.setClientHandshakeTrafficSecret(clientHandshakeTrafficSecret);
            LOGGER.debug("Set clientHandshakeTrafficSecret in Context to {}", (Object)clientHandshakeTrafficSecret);
            byte[] serverHandshakeTrafficSecret = HKDFunction.deriveSecret(hkdfAlgorithm, digestAlgo.getJavaName(), handshakeSecret, "s hs traffic", this.tlsContext.getDigest().getRawBytes(), this.tlsContext.getChooser().getSelectedProtocolVersion());
            this.tlsContext.setServerHandshakeTrafficSecret(serverHandshakeTrafficSecret);
            LOGGER.debug("Set serverHandshakeTrafficSecret in Context to {}", (Object)serverHandshakeTrafficSecret);
        }
        catch (CryptoException | NoSuchAlgorithmException ex) {
            throw new AdjustmentException(ex);
        }
    }

    private byte[] computeSharedPWDSecret(KeyShareStoreEntry keyShare) throws CryptoException {
        Chooser chooser = this.tlsContext.getChooser();
        CyclicGroup group = keyShare.getGroup().getGroupParameters().getGroup();
        if (!(group instanceof EllipticCurve)) {
            LOGGER.warn("Cannot compute sharedPwdSecret for non-EC group. Returning new byte[]");
            return new byte[0];
        }
        EllipticCurve curve = (EllipticCurve)group;
        DragonFlyKeyShareEntryParser parser = new DragonFlyKeyShareEntryParser(new ByteArrayInputStream(keyShare.getPublicKey()), keyShare.getGroup());
        DragonFlyKeyShareEntry dragonFlyKeyShareEntry = new DragonFlyKeyShareEntry();
        parser.parse(dragonFlyKeyShareEntry);
        int curveSize = curve.getModulus().bitLength();
        Point keySharePoint = PointFormatter.fromRawFormat(keyShare.getGroup().getGroupParameters(), (byte[])dragonFlyKeyShareEntry.getRawPublicKey());
        BigInteger scalar = dragonFlyKeyShareEntry.getScalar();
        Point passwordElement = PWDComputations.computePasswordElement(this.tlsContext.getChooser(), curve);
        BigInteger privateKeyScalar = chooser.getConnectionEndType() == ConnectionEndType.CLIENT ? new BigInteger(1, chooser.getConfig().getDefaultClientPWDPrivate()).mod(curve.getBasePointOrder()) : new BigInteger(1, chooser.getConfig().getDefaultServerPWDPrivate()).mod(curve.getBasePointOrder());
        LOGGER.debug("Element: {}", new Supplier[]{() -> PointFormatter.toRawFormat((Point)keySharePoint)});
        LOGGER.debug("Scalar: {}", new Supplier[]{() -> DataConverter.bigIntegerToByteArray((BigInteger)scalar)});
        Point sharedSecret = curve.mult(privateKeyScalar, curve.add(curve.mult(scalar, passwordElement), keySharePoint));
        return DataConverter.bigIntegerToByteArray((BigInteger)sharedSecret.getFieldX().getData(), (int)(curveSize / 8), (boolean)true);
    }

    private void determineEncryptedClientHelloSupport(ServerHelloMessage message, boolean isHelloRetryRequestMessage) {
        byte[] acceptConfirmationServer;
        String label;
        byte[] originalServerHello = (byte[])message.getCompleteResultingMessage().getValue();
        byte[] serverHello = (byte[])originalServerHello.clone();
        if (!isHelloRetryRequestMessage) {
            label = echLabel;
            acceptConfirmationServer = this.acceptConfirmationServer(message, originalServerHello, serverHello);
        } else {
            label = echHrrLabel;
            acceptConfirmationServer = this.acceptConfirmationServerHrr(message, serverHello);
        }
        if (acceptConfirmationServer == null) {
            return;
        }
        byte[] transcriptEchConf = this.computeEchDigest(serverHello);
        this.computeAcceptConfirmation(label, transcriptEchConf, acceptConfirmationServer, message);
    }

    private byte[] acceptConfirmationServer(ServerHelloMessage message, byte[] originalServerHello, byte[] serverHello) {
        if (((byte[])message.getRandom().getValue()).length < 8) {
            LOGGER.warn("Server returned short ClientHello");
            return null;
        }
        byte[] serverRandom = (byte[])message.getRandom().getValue();
        byte[] serverRandomTruncatedPart = Arrays.copyOfRange(serverRandom, serverRandom.length - 8, serverRandom.length);
        int startIndex = HpkeUtil.indexOf(originalServerHello, serverRandomTruncatedPart);
        System.arraycopy(new byte[]{0, 0, 0, 0, 0, 0, 0, 0}, 0, serverHello, startIndex, 8);
        return serverRandomTruncatedPart;
    }

    private byte[] acceptConfirmationServerHrr(ServerHelloMessage message, byte[] serverHello) {
        EncryptedClientHelloExtensionMessage extensionMessage = message.getExtension(EncryptedClientHelloExtensionMessage.class);
        if (extensionMessage == null) {
            LOGGER.debug("The server did not include an encryptedClientHello message in its HelloRetryRequest");
            return null;
        }
        byte[] extensionContent = (byte[])extensionMessage.getAcceptConfirmation().getValue();
        int startIndex = HpkeUtil.indexOf(serverHello, extensionContent);
        System.arraycopy(new byte[]{0, 0, 0, 0, 0, 0, 0, 0}, 0, serverHello, startIndex, 8);
        return extensionContent;
    }

    private byte[] computeEchDigest(byte[] serverHello) {
        byte[] lastClientHello = this.tlsContext.getChooser().getLastClientHello();
        MessageDigestCollector echDigest = new MessageDigestCollector();
        LOGGER.debug("ClientHelloInner: {}", (Object)lastClientHello);
        LOGGER.debug("ServerHello: {}", (Object)serverHello);
        echDigest.append(lastClientHello);
        echDigest.append(serverHello);
        LOGGER.debug("Complete resulting digest: {}", (Object)echDigest.getRawBytes());
        Chooser chooser = this.tlsContext.getChooser();
        byte[] transcriptEchConf = echDigest.digest(chooser.getSelectedProtocolVersion(), chooser.getSelectedCipherSuite());
        LOGGER.debug("Transcript Ech Config: {}", (Object)transcriptEchConf);
        return transcriptEchConf;
    }

    private void computeAcceptConfirmation(String label, byte[] transcriptEchConf, byte[] acceptConfirmationServer, ServerHelloMessage message) {
        Chooser chooser = this.tlsContext.getChooser();
        ClientHelloMessage innerClientHello = chooser.getInnerClientHello();
        HKDFAlgorithm hkdfAlgorithm = AlgorithmResolver.getHKDFAlgorithm(this.tlsContext.getChooser().getSelectedCipherSuite());
        try {
            byte[] extract = HKDFunction.extract(hkdfAlgorithm, null, (byte[])innerClientHello.getRandom().getValue());
            LOGGER.debug("Extract: {}", (Object)extract);
            byte[] acceptConfirmationClient = HKDFunction.expandLabel(hkdfAlgorithm, extract, label, transcriptEchConf, 8, chooser.getSelectedProtocolVersion());
            LOGGER.debug("Accept Confirmation Calculated: {}", (Object)acceptConfirmationClient);
            LOGGER.debug("Accept Confirmation Received: {}", (Object)acceptConfirmationServer);
            if (Arrays.equals(acceptConfirmationClient, acceptConfirmationServer)) {
                this.tlsContext.setSupportsECH(true);
                ClientHelloHandler clientHelloHandler = new ClientHelloHandler(this.tlsContext);
                clientHelloHandler.adjustContext(innerClientHello);
                chooser.getContext().getTlsContext().getDigest().reset();
                clientHelloHandler.updateDigest(innerClientHello, false);
                this.updateDigest(message, false);
                LOGGER.info("Server supports ECH");
            }
        }
        catch (CryptoException e) {
            LOGGER.warn("Could not compute accept confirmation of Server Hello: ", (Throwable)e);
        }
    }

    private void adjustHelloRetryDigest(ServerHelloMessage message) {
        try {
            byte[] lastClientHello = this.tlsContext.getChooser().getLastClientHello();
            LOGGER.debug("Replacing current digest for Hello Retry Request using Client Hello: {}", (Object)lastClientHello);
            DigestAlgorithm algorithm = AlgorithmResolver.getDigestAlgorithm(ProtocolVersion.TLS13, this.tlsContext.getChooser().getSelectedCipherSuite());
            MessageDigest hash = MessageDigest.getInstance(algorithm.getJavaName());
            hash.update(lastClientHello);
            byte[] clientHelloHash = hash.digest();
            byte[] serverHelloBytes = (byte[])message.getCompleteResultingMessage().getValue();
            this.tlsContext.getDigest().setRawBytes(HandshakeMessageType.MESSAGE_HASH.getArrayValue());
            this.tlsContext.getDigest().append(DataConverter.intToBytes((int)clientHelloHash.length, (int)3));
            this.tlsContext.getDigest().append(clientHelloHash);
            this.tlsContext.getDigest().append(serverHelloBytes);
            LOGGER.debug("Complete resulting digest: {}", (Object)this.tlsContext.getDigest().getRawBytes());
        }
        catch (NoSuchAlgorithmException ex) {
            LOGGER.error((Object)ex);
        }
    }

    private void warnOnConflictingExtensions() {
        if (this.tlsContext.getTalkingConnectionEndType() == this.tlsContext.getChooser().getMyConnectionPeer() && !this.tlsContext.getChooser().getSelectedProtocolVersion().is13() && this.tlsContext.isExtensionNegotiated(ExtensionType.MAX_FRAGMENT_LENGTH) && this.tlsContext.isExtensionNegotiated(ExtensionType.RECORD_SIZE_LIMIT)) {
            LOGGER.warn("Server sent max_fragment_length AND record_size_limit extensions");
        }
    }

    private KeyShareStoreEntry adjustKeyShareStoreEntry() {
        KeyShareStoreEntry selectedKeyShareStore;
        if (this.tlsContext.getChooser().getConnectionEndType() == ConnectionEndType.CLIENT) {
            selectedKeyShareStore = this.tlsContext.getChooser().getServerKeyShare();
        } else {
            Integer pos = null;
            for (KeyShareStoreEntry entry : this.tlsContext.getChooser().getClientKeyShares()) {
                if (!Arrays.equals(entry.getGroup().getValue(), this.tlsContext.getChooser().getServerKeyShare().getGroup().getValue())) continue;
                pos = this.tlsContext.getChooser().getClientKeyShares().indexOf(entry);
            }
            if (pos == null) {
                LOGGER.warn("Client did not send the KeyShareType we expected. Choosing first in his List");
                pos = 0;
            }
            selectedKeyShareStore = this.tlsContext.getChooser().getClientKeyShares().get(pos);
        }
        this.tlsContext.setSelectedGroup(selectedKeyShareStore.getGroup());
        if (selectedKeyShareStore.getGroup().isEcGroup()) {
            Point publicPoint = this.tlsContext.getChooser().getSelectedCipherSuite().isPWD() ? PointFormatter.fromRawFormat(selectedKeyShareStore.getGroup().getGroupParameters(), (byte[])selectedKeyShareStore.getPublicKey()) : PointFormatter.formatFromByteArray(selectedKeyShareStore.getGroup().getGroupParameters(), (byte[])selectedKeyShareStore.getPublicKey());
            this.tlsContext.setServerEphemeralEcPublicKey(publicPoint);
        } else {
            this.tlsContext.setServerEphemeralDhPublicKey(new BigInteger(selectedKeyShareStore.getPublicKey()));
        }
        return selectedKeyShareStore;
    }

    private KeySet getKeySet(TlsContext tlsContext, Tls13KeySetType keySetType) {
        try {
            LOGGER.debug("Generating new KeySet");
            KeySet keySet = KeyDerivator.generateKeySet(tlsContext, tlsContext.getChooser().getSelectedProtocolVersion(), keySetType);
            return keySet;
        }
        catch (CryptoException | NoSuchAlgorithmException ex) {
            throw new UnsupportedOperationException("The specified Algorithm is not supported", ex);
        }
    }

    private void precalculateHandshakeKeysClient() {
        KeySet keySet = this.getKeySet(this.tlsContext, Tls13KeySetType.HANDSHAKE_TRAFFIC_SECRETS);
        this.tlsContext.setkeySetHandshake(keySet);
    }
}

