/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler;

import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.handler.ServerKeyExchangeHandler;
import de.rub.nds.tlsattacker.core.protocol.message.SrpServerKeyExchangeMessage;
import java.math.BigInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SrpServerKeyExchangeHandler
extends ServerKeyExchangeHandler<SrpServerKeyExchangeMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public SrpServerKeyExchangeHandler(TlsContext tlsContext) {
        super(tlsContext);
    }

    @Override
    public void adjustContext(SrpServerKeyExchangeMessage message) {
        this.adjustSRPGenerator(message);
        this.adjustSRPModulus(message);
        this.adjustSalt(message);
        this.adjustServerPublicKey(message);
        this.adjustSelectedSignatureAndHashAlgorithm(message);
        if (message.getKeyExchangeComputations() != null && message.getKeyExchangeComputations().getPrivateKey() != null) {
            this.adjustServerPrivateKey(message);
        }
    }

    private void adjustSRPGenerator(SrpServerKeyExchangeMessage message) {
        this.tlsContext.setSRPGenerator(new BigInteger(1, (byte[])message.getGenerator().getValue()));
        LOGGER.debug("SRP Generator: {}", (Object)this.tlsContext.getSRPGenerator());
    }

    private void adjustSRPModulus(SrpServerKeyExchangeMessage message) {
        this.tlsContext.setSRPModulus(new BigInteger(1, (byte[])message.getModulus().getValue()));
        LOGGER.debug("SRP Modulus: {}", (Object)this.tlsContext.getSRPModulus());
    }

    private void adjustServerPublicKey(SrpServerKeyExchangeMessage message) {
        this.tlsContext.setServerSRPPublicKey(new BigInteger(1, (byte[])message.getPublicKey().getValue()));
        LOGGER.debug("Server PublicKey: {}", (Object)this.tlsContext.getServerSRPPublicKey());
    }

    private void adjustServerPrivateKey(SrpServerKeyExchangeMessage message) {
        this.tlsContext.setServerSRPPrivateKey((BigInteger)message.getKeyExchangeComputations().getPrivateKey().getValue());
        LOGGER.debug("Server PrivateKey: {}", (Object)this.tlsContext.getServerSRPPrivateKey());
    }

    private void adjustSalt(SrpServerKeyExchangeMessage message) {
        this.tlsContext.setSRPServerSalt((byte[])message.getSalt().getValue());
        LOGGER.debug("SRP Salt: {}", (Object)this.tlsContext.getSRPServerSalt());
    }
}

