/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler.extension;

import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.protocol.exception.CryptoException;
import de.rub.nds.protocol.exception.ParserException;
import de.rub.nds.tlsattacker.core.constants.EchClientHelloType;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.crypto.hpke.HpkeReceiverContext;
import de.rub.nds.tlsattacker.core.crypto.hpke.HpkeUtil;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.handler.ClientHelloHandler;
import de.rub.nds.tlsattacker.core.protocol.handler.extension.ExtensionHandler;
import de.rub.nds.tlsattacker.core.protocol.message.ClientHelloMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.EchConfig;
import de.rub.nds.tlsattacker.core.protocol.message.extension.EncryptedClientHelloExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.keyshare.KeyShareEntry;
import de.rub.nds.tlsattacker.core.protocol.parser.ClientHelloParser;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EncryptedClientHelloExtensionHandler
extends ExtensionHandler<EncryptedClientHelloExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public EncryptedClientHelloExtensionHandler(TlsContext tlsContext) {
        super(tlsContext);
    }

    @Override
    public void adjustTLSExtensionContext(EncryptedClientHelloExtensionMessage message) {
        if (this.tlsContext.getConnection().getLocalConnectionEndType() == ConnectionEndType.SERVER && message.getEchClientHelloType() == EchClientHelloType.OUTER) {
            byte[] encodedClientHelloInner;
            EchConfig echConfig = this.tlsContext.getChooser().getEchConfig();
            if (((Integer)message.getConfigId().getValue()).intValue() != echConfig.getConfigId()) {
                LOGGER.warn("ECHConfig id's do not match");
            }
            LOGGER.debug("Received ECH Config ID: {}", message.getConfigId().getValue());
            LOGGER.debug("Own ECH Config ID: {}", (Object)echConfig.getConfigId());
            HpkeUtil hpkeUtil = new HpkeUtil(echConfig);
            KeyShareEntry keyShareEntry = this.tlsContext.getChooser().getEchServerKeyShareEntry();
            LOGGER.debug("ServerPrivateKey: {}", (Object)keyShareEntry.getPrivateKey().toByteArray());
            LOGGER.debug("ServerPublicKey: {}", keyShareEntry.getPublicKey().getValue());
            byte[] info = DataConverter.concatenate((byte[][])new byte[][]{"tls ech".getBytes(StandardCharsets.US_ASCII), {0}, echConfig.getEchConfigBytes()});
            LOGGER.debug("Info: {}", (Object)info);
            byte[] payload = (byte[])message.getPayload().getValue();
            LOGGER.debug("Payload: {}", (Object)payload);
            byte[] aad = Arrays.copyOfRange(this.tlsContext.getLastClientHello(), 4, this.tlsContext.getLastClientHello().length);
            int startIndex = HpkeUtil.indexOf(aad, payload);
            System.arraycopy(new byte[payload.length], 0, aad, startIndex, payload.length);
            LOGGER.debug("AAD: {}", (Object)aad);
            try {
                HpkeReceiverContext receiverContext = hpkeUtil.setupBaseReceiver((byte[])message.getEnc().getValue(), info, keyShareEntry);
                encodedClientHelloInner = receiverContext.open(aad, payload);
                LOGGER.debug("Encoded ClientHello Inner: {}", (Object)encodedClientHelloInner);
            }
            catch (CryptoException e) {
                LOGGER.warn("Could not decrypt the sent ECH (tag mismatch?): ", (Throwable)e);
                return;
            }
            LOGGER.debug("Encoded client hello inner: {}", (Object)encodedClientHelloInner);
            byte[] type = new byte[]{HandshakeMessageType.CLIENT_HELLO.getValue()};
            ClientHelloMessage clientHelloMessage = new ClientHelloMessage();
            try {
                ClientHelloParser clientHelloParser = new ClientHelloParser(new ByteArrayInputStream(encodedClientHelloInner), this.tlsContext);
                clientHelloParser.parse(clientHelloMessage);
                int clientHelloMessageLength = clientHelloParser.getAlreadyParsed().length;
                byte[] clientHelloLength = DataConverter.intToBytes((int)clientHelloMessageLength, (int)3);
                clientHelloMessage.setLength(clientHelloMessageLength);
                clientHelloMessage.setCompleteResultingMessage(DataConverter.concatenate((byte[][])new byte[][]{type, clientHelloLength, clientHelloParser.getAlreadyParsed()}));
            }
            catch (ParserException e) {
                LOGGER.warn("Could not parse decrypted ClientHello", (Throwable)e);
                return;
            }
            this.tlsContext.setSupportsECH(true);
            ClientHelloHandler clientHelloHandler = new ClientHelloHandler(this.tlsContext);
            clientHelloHandler.adjustContext(clientHelloMessage);
            this.tlsContext.getDigest().reset();
            clientHelloHandler.updateDigest(clientHelloMessage, true);
            LOGGER.info("Client supports ECH");
        }
    }
}

