/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler.extension;

import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.handler.extension.ExtensionHandler;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ExtendedRandomExtensionMessage;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExtendedRandomExtensionHandler
extends ExtensionHandler<ExtendedRandomExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public ExtendedRandomExtensionHandler(TlsContext tlsContext) {
        super(tlsContext);
    }

    @Override
    public void adjustTLSExtensionContext(ExtendedRandomExtensionMessage message) {
        if (this.tlsContext.getTalkingConnectionEndType().equals((Object)ConnectionEndType.SERVER)) {
            this.tlsContext.setServerExtendedRandom((byte[])message.getExtendedRandom().getValue());
            LOGGER.debug("The context server extended Random was set to {}", (Object)message.getExtendedRandom());
        }
        if (this.tlsContext.getTalkingConnectionEndType().equals((Object)ConnectionEndType.CLIENT)) {
            this.tlsContext.setClientExtendedRandom((byte[])message.getExtendedRandom().getValue());
            LOGGER.debug("The context client extended Random was set to {}", (Object)message.getExtendedRandom());
        }
        if (this.tlsContext.getClientExtendedRandom() != null && this.tlsContext.getServerExtendedRandom() != null) {
            LOGGER.debug("Extended Random was agreed on. Concatenating extended Randoms to normal Randoms.");
            byte[] clientConcatRandom = DataConverter.concatenate((byte[][])new byte[][]{this.tlsContext.getClientRandom(), this.tlsContext.getClientExtendedRandom()});
            byte[] serverConcatRandom = DataConverter.concatenate((byte[][])new byte[][]{this.tlsContext.getServerRandom(), this.tlsContext.getServerExtendedRandom()});
            this.tlsContext.setClientRandom(clientConcatRandom);
            LOGGER.debug("ClientRandom: {}", (Object)this.tlsContext.getClientRandom());
            this.tlsContext.setServerRandom(serverConcatRandom);
            LOGGER.debug("ServerRandom: {}", (Object)this.tlsContext.getServerRandom());
        }
    }
}

