/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler.extension;

import de.rub.nds.tlsattacker.core.constants.NamedGroup;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.handler.extension.ExtensionHandler;
import de.rub.nds.tlsattacker.core.protocol.message.extension.KeyShareExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.keyshare.KeyShareEntry;
import de.rub.nds.tlsattacker.core.protocol.message.extension.keyshare.KeyShareStoreEntry;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KeyShareExtensionHandler
extends ExtensionHandler<KeyShareExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public KeyShareExtensionHandler(TlsContext tlsContext) {
        super(tlsContext);
    }

    @Override
    public void adjustTLSExtensionContext(KeyShareExtensionMessage message) {
        if (message.isRetryRequestMode()) {
            this.adjustRetryRequestKeyShare(message);
        } else {
            List<KeyShareStoreEntry> ksEntryList = this.createKeyShareStoreEntries(message);
            if (this.tlsContext.getTalkingConnectionEndType() == ConnectionEndType.SERVER) {
                this.adjustServerKeyShareStore(ksEntryList);
            } else {
                this.tlsContext.setClientKeyShareStoreEntryList(ksEntryList);
            }
        }
    }

    private List<KeyShareStoreEntry> createKeyShareStoreEntries(KeyShareExtensionMessage message) {
        LinkedList<KeyShareStoreEntry> ksEntryList = new LinkedList<KeyShareStoreEntry>();
        for (KeyShareEntry pair : message.getKeyShareList()) {
            NamedGroup type = NamedGroup.getNamedGroup((byte[])pair.getGroup().getValue());
            if (type != null) {
                if (pair.getPublicKey() != null && pair.getPublicKey().getValue() != null) {
                    ksEntryList.add(new KeyShareStoreEntry(type, (byte[])pair.getPublicKey().getValue()));
                    continue;
                }
                LOGGER.warn("Empty KeyShare - Setting only selected KeyShareType: to {}", (Object)pair.getGroup());
                this.tlsContext.setSelectedGroup(type);
                continue;
            }
            LOGGER.warn("Unknown KS Type: {}", pair.getPublicKey().getValue());
        }
        return ksEntryList;
    }

    private void adjustServerKeyShareStore(List<KeyShareStoreEntry> ksEntryList) {
        if (!ksEntryList.isEmpty()) {
            this.tlsContext.setServerKeyShareStoreEntry(new KeyShareStoreEntry(ksEntryList.get(0).getGroup(), ksEntryList.get(0).getPublicKey()));
            NamedGroup selectedGroup = this.tlsContext.getServerKeyShareStoreEntry().getGroup();
            LOGGER.debug("Setting selected NamedGroup in context to {}", (Object)selectedGroup);
            this.tlsContext.setSelectedGroup(selectedGroup);
        }
    }

    private void adjustRetryRequestKeyShare(KeyShareExtensionMessage message) {
        if (!message.getKeyShareList().isEmpty()) {
            NamedGroup selectedGroup = message.getKeyShareList().get(0).getGroupConfig();
            LOGGER.debug("Setting selected NamedGroup from HelloRetryRequest in context to {}", (Object)selectedGroup);
            this.tlsContext.setSelectedGroup(selectedGroup);
        }
    }
}

