/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler.extension;

import de.rub.nds.tlsattacker.core.constants.CertificateType;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.handler.extension.ExtensionHandler;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ServerCertificateTypeExtensionMessage;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerCertificateTypeExtensionHandler
extends ExtensionHandler<ServerCertificateTypeExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public ServerCertificateTypeExtensionHandler(TlsContext tlsContext) {
        super(tlsContext);
    }

    @Override
    public void adjustTLSExtensionContext(ServerCertificateTypeExtensionMessage message) {
        if (this.tlsContext.getTalkingConnectionEndType() == ConnectionEndType.SERVER) {
            if (((byte[])message.getCertificateTypes().getValue()).length != 1) {
                LOGGER.warn("Invalid ServerCertificateType extension. Not adjusting context");
            } else {
                this.tlsContext.setSelectedServerCertificateType(CertificateType.getCertificateType(((byte[])message.getCertificateTypes().getValue())[0]));
            }
        } else {
            this.tlsContext.setServerCertificateTypeDesiredTypes(CertificateType.getCertificateTypesAsList((byte[])message.getCertificateTypes().getValue()));
        }
    }
}

