/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler.extension;

import de.rub.nds.tlsattacker.core.constants.SniType;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.handler.extension.ExtensionHandler;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ServerNameIndicationExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.sni.SNIEntry;
import de.rub.nds.tlsattacker.core.protocol.message.extension.sni.ServerNamePair;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerNameIndicationExtensionHandler
extends ExtensionHandler<ServerNameIndicationExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public ServerNameIndicationExtensionHandler(TlsContext tlsContext) {
        super(tlsContext);
    }

    @Override
    public void adjustTLSExtensionContext(ServerNameIndicationExtensionMessage message) {
        LinkedList<SNIEntry> sniEntryList = new LinkedList<SNIEntry>();
        for (ServerNamePair pair : message.getServerNameList()) {
            SniType type = SniType.getNameType((Byte)pair.getServerNameType().getValue());
            if (type != null) {
                sniEntryList.add(new SNIEntry(new String((byte[])pair.getServerName().getValue(), StandardCharsets.ISO_8859_1), type));
                continue;
            }
            LOGGER.warn("Unknown SNI Type: {}", pair.getServerNameType().getValue());
        }
        this.tlsContext.setClientSNIEntryList(sniEntryList);
    }
}

