/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler.extension;

import de.rub.nds.protocol.exception.CryptoException;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.handler.extension.ExtensionHandler;
import de.rub.nds.tlsattacker.core.protocol.message.extension.SessionTicketTLSExtensionMessage;
import de.rub.nds.tlsattacker.core.state.StatePlaintext;
import de.rub.nds.tlsattacker.core.state.parser.StatePlaintextParser;
import de.rub.nds.tlsattacker.core.util.StaticTicketCrypto;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SessionTicketTLSExtensionHandler
extends ExtensionHandler<SessionTicketTLSExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public SessionTicketTLSExtensionHandler(TlsContext context) {
        super(context);
    }

    @Override
    public void adjustTLSExtensionContext(SessionTicketTLSExtensionMessage message) {
        if ((Integer)message.getExtensionLength().getValue() > 65535) {
            LOGGER.warn("The SessionTLS ticket length shouldn't exceed 2 bytes as defined in RFC 4507. Length was " + String.valueOf(message.getExtensionLength().getValue()));
        }
        if ((Integer)message.getExtensionLength().getValue() > 0) {
            StatePlaintext statePlaintext;
            LOGGER.debug("Adjusting for client offered session ticket");
            if (this.tlsContext.getTalkingConnectionEndType() != this.tlsContext.getChooser().getConnectionEndType() && (statePlaintext = this.getStateFromTicket(message)) != null) {
                LOGGER.info("Resuming Session using Ticket");
                LOGGER.debug("Restoring MasterSecret from SessionTicket");
                this.tlsContext.setMasterSecret((byte[])statePlaintext.getMasterSecret().getValue());
                if (this.tlsContext.getClientSessionId().length > 0) {
                    LOGGER.debug("Setting ServerSessionId equal to ClientSessionId");
                    this.tlsContext.setServerSessionId((byte[])this.tlsContext.getClientSessionId().clone());
                }
            }
        } else if (this.tlsContext.getTalkingConnectionEndType() == ConnectionEndType.CLIENT && this.tlsContext.getChooser().getConnectionEndType() == ConnectionEndType.SERVER && this.tlsContext.getConfig().isOverrideSessionIdForTickets().booleanValue() && this.tlsContext.getConfig().isAddSessionTicketTLSExtension().booleanValue()) {
            this.tlsContext.setServerSessionId(new byte[0]);
        }
    }

    private StatePlaintext getStateFromTicket(SessionTicketTLSExtensionMessage message) {
        if (message.getSessionTicket() == null || message.getSessionTicket().getEncryptedState() == null) {
            return null;
        }
        try {
            byte[] decryptedState = this.decryptState((byte[])message.getSessionTicket().getEncryptedState().getValue(), (byte[])message.getSessionTicket().getIV().getValue());
            StatePlaintextParser stateParser = new StatePlaintextParser(0, decryptedState);
            StatePlaintext plainState = new StatePlaintext();
            plainState.generateStatePlaintext(this.tlsContext.getChooser());
            stateParser.parse(plainState);
            return plainState;
        }
        catch (CryptoException ex) {
            LOGGER.warn("Was unable to decrypt session ticket ", (Throwable)ex);
            return null;
        }
    }

    private byte[] decryptState(byte[] encryptedState, byte[] iv) throws CryptoException {
        Config config = this.tlsContext.getConfig();
        return StaticTicketCrypto.decrypt(config.getSessionTicketCipherAlgorithm(), encryptedState, config.getSessionTicketEncryptionKey(), iv);
    }
}

