/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler.extension;

import de.rub.nds.tlsattacker.core.constants.SignatureAndHashAlgorithm;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.handler.extension.ExtensionHandler;
import de.rub.nds.tlsattacker.core.protocol.message.extension.SignatureAndHashAlgorithmsExtensionMessage;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SignatureAndHashAlgorithmsExtensionHandler
extends ExtensionHandler<SignatureAndHashAlgorithmsExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public SignatureAndHashAlgorithmsExtensionHandler(TlsContext tlsContext) {
        super(tlsContext);
    }

    @Override
    public void adjustTLSExtensionContext(SignatureAndHashAlgorithmsExtensionMessage message) {
        byte[] algoBytes = (byte[])message.getSignatureAndHashAlgorithms().getValue();
        List<SignatureAndHashAlgorithm> algoList = SignatureAndHashAlgorithm.getSignatureAndHashAlgorithms(algoBytes);
        this.tlsContext.setClientSupportedSignatureAndHashAlgorithms(algoList);
        LOGGER.debug("Client supported signatureAndHashAlgorithms: {}", algoList);
    }
}

