/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler.extension;

import de.rub.nds.tlsattacker.core.constants.TokenBindingKeyParameters;
import de.rub.nds.tlsattacker.core.constants.TokenBindingVersion;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.handler.extension.ExtensionHandler;
import de.rub.nds.tlsattacker.core.protocol.message.extension.TokenBindingExtensionMessage;
import java.util.ArrayList;

public class TokenBindingExtensionHandler
extends ExtensionHandler<TokenBindingExtensionMessage> {
    public TokenBindingExtensionHandler(TlsContext tlsContext) {
        super(tlsContext);
    }

    @Override
    public void adjustTLSExtensionContext(TokenBindingExtensionMessage message) {
        this.tlsContext.setTokenBindingVersion(TokenBindingVersion.getExtensionType((byte[])message.getTokenBindingVersion().getValue()));
        ArrayList<TokenBindingKeyParameters> tokenbindingKeyParameters = new ArrayList<TokenBindingKeyParameters>();
        for (byte kp : (byte[])message.getTokenBindingKeyParameters().getValue()) {
            tokenbindingKeyParameters.add(TokenBindingKeyParameters.getTokenBindingKeyParameter(kp));
        }
        this.tlsContext.setTokenBindingKeyParameters(tokenbindingKeyParameters);
        if (this.tlsContext.getTalkingConnectionEndType() == this.tlsContext.getChooser().getMyConnectionPeer()) {
            this.tlsContext.setTokenBindingNegotiatedSuccessfully(true);
        }
    }
}

