/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message;

import de.rub.nds.modifiablevariable.HoldsModifiableVariable;
import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.integer.ModifiableInteger;
import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.protocol.handler.CertificateMessageHandler;
import de.rub.nds.tlsattacker.core.protocol.message.HandshakeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.cert.CertificateEntry;
import de.rub.nds.tlsattacker.core.protocol.parser.CertificateMessageParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.CertificateMessagePreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.CertificateMessageSerializer;
import de.rub.nds.tlsattacker.core.state.Context;
import de.rub.nds.x509attacker.x509.model.X509Certificate;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

@XmlRootElement(name="Certificate")
public class CertificateMessage
extends HandshakeMessage {
    @ModifiableVariableProperty(purpose=ModifiableVariableProperty.Purpose.LENGTH)
    private ModifiableInteger requestContextLength;
    @ModifiableVariableProperty
    private ModifiableByteArray requestContext;
    @ModifiableVariableProperty(purpose=ModifiableVariableProperty.Purpose.LENGTH)
    private ModifiableInteger certificatesListLength;
    @ModifiableVariableProperty
    private ModifiableByteArray certificatesListBytes;
    @HoldsModifiableVariable
    @XmlElementWrapper
    @XmlElement(name="certificatesList")
    private List<CertificateEntry> certificateEntryList;

    public CertificateMessage() {
        super(HandshakeMessageType.CERTIFICATE);
    }

    public ModifiableInteger getCertificatesListLength() {
        return this.certificatesListLength;
    }

    public void setCertificatesListLength(ModifiableInteger certificatesListLength) {
        this.certificatesListLength = certificatesListLength;
    }

    public void setCertificatesListLength(int length) {
        this.certificatesListLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.certificatesListLength, (Integer)length);
    }

    public ModifiableByteArray getCertificatesListBytes() {
        return this.certificatesListBytes;
    }

    public void setCertificatesListBytes(ModifiableByteArray certificatesListBytes) {
        this.certificatesListBytes = certificatesListBytes;
    }

    public void setCertificatesListBytes(byte[] array) {
        this.certificatesListBytes = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.certificatesListBytes, (byte[])array);
    }

    public ModifiableInteger getRequestContextLength() {
        return this.requestContextLength;
    }

    public void setRequestContextLength(ModifiableInteger requestContextLength) {
        this.requestContextLength = requestContextLength;
    }

    public void setRequestContextLength(int length) {
        this.requestContextLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.requestContextLength, (Integer)length);
    }

    public ModifiableByteArray getRequestContext() {
        return this.requestContext;
    }

    public void setRequestContext(ModifiableByteArray requestContext) {
        this.requestContext = requestContext;
    }

    public void setRequestContext(byte[] array) {
        this.requestContext = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.requestContext, (byte[])array);
    }

    public boolean hasRequestContext() {
        return (Integer)this.requestContextLength.getValue() > 0;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CertificateMessage:");
        sb.append("\n  Certificates Length: ");
        if (this.certificatesListLength != null && this.certificatesListLength.getValue() != null) {
            sb.append(this.certificatesListLength.getValue());
        } else {
            sb.append("null");
        }
        sb.append("\n  Certificate:\n");
        if (this.certificatesListBytes != null && this.certificatesListBytes.getValue() != null) {
            sb.append(DataConverter.bytesToHexString((byte[])((byte[])this.certificatesListBytes.getValue())));
        } else {
            sb.append("null");
        }
        return sb.toString();
    }

    @Override
    public String toShortString() {
        return "CERT";
    }

    @Override
    public CertificateMessageParser getParser(Context context, InputStream stream) {
        return new CertificateMessageParser(stream, context.getTlsContext());
    }

    @Override
    public CertificateMessagePreparator getPreparator(Context context) {
        return new CertificateMessagePreparator(context.getChooser(), this);
    }

    @Override
    public CertificateMessageSerializer getSerializer(Context context) {
        return new CertificateMessageSerializer(this, context.getChooser().getSelectedProtocolVersion());
    }

    @Override
    public CertificateMessageHandler getHandler(Context context) {
        return new CertificateMessageHandler(context.getTlsContext());
    }

    public List<CertificateEntry> getCertificateEntryList() {
        return this.certificateEntryList;
    }

    public void setCertificateEntryList(List<CertificateEntry> certificateEntryList) {
        this.certificateEntryList = certificateEntryList;
    }

    public List<X509Certificate> getX509CertificateListFromEntries() {
        LinkedList<X509Certificate> x509CertificateList = new LinkedList<X509Certificate>();
        for (CertificateEntry entry : this.certificateEntryList) {
            x509CertificateList.add(entry.getX509certificate());
        }
        return x509CertificateList;
    }

    public int hashCode() {
        int hash = 7;
        hash = 41 * hash + Objects.hashCode(this.requestContextLength);
        hash = 41 * hash + Objects.hashCode(this.requestContext);
        hash = 41 * hash + Objects.hashCode(this.certificatesListLength);
        hash = 41 * hash + Objects.hashCode(this.certificatesListBytes);
        hash = 41 * hash + Objects.hashCode(this.certificateEntryList);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CertificateMessage other = (CertificateMessage)obj;
        if (!Objects.equals(this.requestContextLength, other.requestContextLength)) {
            return false;
        }
        if (!Objects.equals(this.requestContext, other.requestContext)) {
            return false;
        }
        if (!Objects.equals(this.certificatesListLength, other.certificatesListLength)) {
            return false;
        }
        if (!Objects.equals(this.certificatesListBytes, other.certificatesListBytes)) {
            return false;
        }
        return Objects.equals(this.certificateEntryList, other.certificateEntryList);
    }
}

