/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message;

import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.integer.ModifiableInteger;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.protocol.handler.CertificateStatusHandler;
import de.rub.nds.tlsattacker.core.protocol.message.HandshakeMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.CertificateStatusParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.CertificateStatusPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.CertificateStatusSerializer;
import de.rub.nds.tlsattacker.core.state.Context;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.InputStream;
import java.util.Objects;

@XmlRootElement(name="CertificateStatus")
public class CertificateStatusMessage
extends HandshakeMessage {
    @ModifiableVariableProperty
    private ModifiableInteger certificateStatusType;
    @ModifiableVariableProperty(purpose=ModifiableVariableProperty.Purpose.LENGTH)
    private ModifiableInteger ocspResponseLength;
    @ModifiableVariableProperty
    private ModifiableByteArray ocspResponseBytes;

    public CertificateStatusMessage() {
        super(HandshakeMessageType.CERTIFICATE_STATUS);
    }

    @Override
    public CertificateStatusHandler getHandler(Context context) {
        return new CertificateStatusHandler(context.getTlsContext());
    }

    @Override
    public CertificateStatusParser getParser(Context context, InputStream stream) {
        return new CertificateStatusParser(stream, context.getTlsContext());
    }

    @Override
    public CertificateStatusPreparator getPreparator(Context context) {
        return new CertificateStatusPreparator(context.getChooser(), this);
    }

    @Override
    public CertificateStatusSerializer getSerializer(Context context) {
        return new CertificateStatusSerializer(this);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CertificateStatusMessage");
        return builder.toString();
    }

    @Override
    public String toShortString() {
        return "CERT_STAT";
    }

    public ModifiableInteger getCertificateStatusType() {
        return this.certificateStatusType;
    }

    public void setCertificateStatusType(int certificateStatusType) {
        this.certificateStatusType = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.certificateStatusType, (Integer)certificateStatusType);
    }

    public void setCertificateStatusType(ModifiableInteger certificateStatusType) {
        this.certificateStatusType = certificateStatusType;
    }

    public ModifiableInteger getOcspResponseLength() {
        return this.ocspResponseLength;
    }

    public void setOcspResponseLength(int ocspResponseLength) {
        this.ocspResponseLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.ocspResponseLength, (Integer)ocspResponseLength);
    }

    public void setOcspResponseLength(ModifiableInteger ocspResponseLength) {
        this.ocspResponseLength = ocspResponseLength;
    }

    public ModifiableByteArray getOcspResponseBytes() {
        return this.ocspResponseBytes;
    }

    public void setOcspResponseBytes(byte[] ocspResponseBytes) {
        this.ocspResponseBytes = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.ocspResponseBytes, (byte[])ocspResponseBytes);
    }

    public void setOcspResponseBytes(ModifiableByteArray ocspResponseBytes) {
        this.ocspResponseBytes = ocspResponseBytes;
    }

    public int hashCode() {
        int hash = 7;
        hash = 23 * hash + Objects.hashCode(this.certificateStatusType);
        hash = 23 * hash + Objects.hashCode(this.ocspResponseLength);
        hash = 23 * hash + Objects.hashCode(this.ocspResponseBytes);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CertificateStatusMessage other = (CertificateStatusMessage)obj;
        if (!Objects.equals(this.certificateStatusType, other.certificateStatusType)) {
            return false;
        }
        if (!Objects.equals(this.ocspResponseLength, other.ocspResponseLength)) {
            return false;
        }
        return Objects.equals(this.ocspResponseBytes, other.ocspResponseBytes);
    }
}

