/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message;

import de.rub.nds.modifiablevariable.HoldsModifiableVariable;
import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.integer.ModifiableInteger;
import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.protocol.constants.SignatureAlgorithm;
import de.rub.nds.protocol.crypto.signature.SignatureCalculator;
import de.rub.nds.protocol.crypto.signature.SignatureComputations;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.protocol.handler.CertificateVerifyHandler;
import de.rub.nds.tlsattacker.core.protocol.message.HandshakeMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.CertificateVerifyParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.CertificateVerifyPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.CertificateVerifySerializer;
import de.rub.nds.tlsattacker.core.state.Context;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.InputStream;
import java.util.Objects;

@XmlRootElement(name="CertificateVerify")
public class CertificateVerifyMessage
extends HandshakeMessage {
    @ModifiableVariableProperty
    private ModifiableByteArray signatureHashAlgorithm;
    @ModifiableVariableProperty(purpose=ModifiableVariableProperty.Purpose.LENGTH)
    private ModifiableInteger signatureLength;
    @ModifiableVariableProperty
    private ModifiableByteArray signature;
    @HoldsModifiableVariable
    private SignatureComputations signatureComputations;

    public CertificateVerifyMessage() {
        super(HandshakeMessageType.CERTIFICATE_VERIFY);
    }

    public SignatureComputations getSignatureComputations(SignatureAlgorithm algorithm) {
        if (this.signatureComputations == null) {
            SignatureCalculator calculator = new SignatureCalculator();
            this.signatureComputations = calculator.createSignatureComputations(algorithm);
        }
        return this.signatureComputations;
    }

    public ModifiableByteArray getSignatureHashAlgorithm() {
        return this.signatureHashAlgorithm;
    }

    public void setSignatureHashAlgorithm(ModifiableByteArray signatureHashAlgorithm) {
        this.signatureHashAlgorithm = signatureHashAlgorithm;
    }

    public void setSignatureHashAlgorithm(byte[] signatureHashAlgorithm) {
        this.signatureHashAlgorithm = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.signatureHashAlgorithm, (byte[])signatureHashAlgorithm);
    }

    public ModifiableInteger getSignatureLength() {
        return this.signatureLength;
    }

    public void setSignatureLength(ModifiableInteger signatureLength) {
        this.signatureLength = signatureLength;
    }

    public void setSignatureLength(int length) {
        this.signatureLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.signatureLength, (Integer)length);
    }

    public ModifiableByteArray getSignature() {
        return this.signature;
    }

    public void setSignature(ModifiableByteArray signature) {
        this.signature = signature;
    }

    public void setSignature(byte[] signature) {
        this.signature = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.signature, (byte[])signature);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CertificateVerifyMessage:");
        builder.append("\n  SignatureAndHashAlgorithm: ");
        if (this.signatureHashAlgorithm != null && this.signatureHashAlgorithm.getValue() != null) {
            builder.append(DataConverter.bytesToHexString((byte[])((byte[])this.signatureHashAlgorithm.getValue())));
        } else {
            builder.append("null");
        }
        builder.append("\n  Signature Length: ");
        if (this.signatureLength != null && this.signatureLength.getValue() != null) {
            builder.append(this.signatureLength.getValue());
        } else {
            builder.append("null");
        }
        builder.append("\n  Signature: ");
        if (this.signature != null && this.signature.getValue() != null) {
            builder.append(DataConverter.bytesToHexString((byte[])((byte[])this.signature.getValue())));
        } else {
            builder.append("null");
        }
        return builder.toString();
    }

    @Override
    public String toShortString() {
        return "CV";
    }

    @Override
    public CertificateVerifyHandler getHandler(Context context) {
        return new CertificateVerifyHandler(context.getTlsContext());
    }

    @Override
    public CertificateVerifyParser getParser(Context context, InputStream stream) {
        return new CertificateVerifyParser(stream, context.getTlsContext());
    }

    @Override
    public CertificateVerifyPreparator getPreparator(Context context) {
        return new CertificateVerifyPreparator(context.getChooser(), this);
    }

    @Override
    public CertificateVerifySerializer getSerializer(Context context) {
        return new CertificateVerifySerializer(this, context.getChooser().getSelectedProtocolVersion());
    }

    public int hashCode() {
        int hash = 5;
        hash = 29 * hash + Objects.hashCode(this.signatureHashAlgorithm);
        hash = 29 * hash + Objects.hashCode(this.signatureLength);
        hash = 29 * hash + Objects.hashCode(this.signature);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CertificateVerifyMessage other = (CertificateVerifyMessage)obj;
        if (!Objects.equals(this.signatureHashAlgorithm, other.signatureHashAlgorithm)) {
            return false;
        }
        if (!Objects.equals(this.signatureLength, other.signatureLength)) {
            return false;
        }
        return Objects.equals(this.signature, other.signature);
    }
}

