/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message;

import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.tlsattacker.core.constants.ProtocolMessageType;
import de.rub.nds.tlsattacker.core.protocol.ProtocolMessage;
import de.rub.nds.tlsattacker.core.protocol.handler.ChangeCipherSpecHandler;
import de.rub.nds.tlsattacker.core.protocol.parser.ChangeCipherSpecParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.ChangeCipherSpecPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.ChangeCipherSpecSerializer;
import de.rub.nds.tlsattacker.core.state.Context;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.InputStream;
import java.util.Objects;

@XmlRootElement(name="ChangeCipherSpec")
public class ChangeCipherSpecMessage
extends ProtocolMessage {
    @ModifiableVariableProperty
    private ModifiableByteArray ccsProtocolType;

    public ChangeCipherSpecMessage() {
        this.protocolMessageType = ProtocolMessageType.CHANGE_CIPHER_SPEC;
    }

    public ModifiableByteArray getCcsProtocolType() {
        return this.ccsProtocolType;
    }

    public void setCcsProtocolType(ModifiableByteArray ccsProtocolType) {
        this.ccsProtocolType = ccsProtocolType;
    }

    public void setCcsProtocolType(byte[] value) {
        this.ccsProtocolType = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.ccsProtocolType, (byte[])value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ChangeCipherSpecMessage:");
        sb.append("\n  CCS ProtocolType: ");
        if (this.ccsProtocolType != null && this.ccsProtocolType.getValue() != null) {
            sb.append(DataConverter.bytesToHexString((byte[])((byte[])this.ccsProtocolType.getValue())));
        } else {
            sb.append("null");
        }
        return sb.toString();
    }

    @Override
    public String toShortString() {
        return "CCS";
    }

    @Override
    public String toCompactString() {
        return "CHANGE_CIPHER_SPEC";
    }

    @Override
    public ChangeCipherSpecHandler getHandler(Context context) {
        return new ChangeCipherSpecHandler(context.getTlsContext());
    }

    @Override
    public ChangeCipherSpecParser getParser(Context context, InputStream stream) {
        return new ChangeCipherSpecParser(stream);
    }

    @Override
    public ChangeCipherSpecPreparator getPreparator(Context context) {
        return new ChangeCipherSpecPreparator(context.getChooser(), this);
    }

    @Override
    public ChangeCipherSpecSerializer getSerializer(Context context) {
        return new ChangeCipherSpecSerializer(this);
    }

    public int hashCode() {
        int hash = 7;
        hash = 71 * hash + Objects.hashCode(this.ccsProtocolType);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChangeCipherSpecMessage other = (ChangeCipherSpecMessage)obj;
        return Objects.equals(this.ccsProtocolType, other.ccsProtocolType);
    }
}

