/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message;

import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.integer.ModifiableInteger;
import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.protocol.message.HelloMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.AlpnExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.CachedInfoExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.CertificateStatusRequestExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.CertificateStatusRequestV2ExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.CertificateTypeExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ClientAuthzExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ClientCertificateTypeExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ClientCertificateUrlExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ConnectionIdExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.CookieExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.DebugExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ECPointFormatExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.EarlyDataExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.EllipticCurvesExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.EncryptThenMacExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.EncryptedServerNameIndicationExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ExtendedMasterSecretExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ExtendedRandomExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.HeartbeatExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.KeyShareExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.MaxFragmentLengthExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.PSKKeyExchangeModesExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.PWDClearExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.PWDProtectExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.PaddingExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.PreSharedKeyExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.RecordSizeLimitExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.RenegotiationInfoExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.SRPExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ServerAuthzExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ServerCertificateTypeExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ServerNameIndicationExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.SessionTicketTLSExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.SignatureAlgorithmsCertExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.SignatureAndHashAlgorithmsExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.SignedCertificateTimestampExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.SrtpExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.SupportedVersionsExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.TokenBindingExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.TruncatedHmacExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.TrustedCaIndicationExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.UserMappingExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.quic.QuicTransportParametersExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.sni.ServerNamePair;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class CoreClientHelloMessage
extends HelloMessage {
    private static final Logger LOGGER = LogManager.getLogger();
    @ModifiableVariableProperty(purpose=ModifiableVariableProperty.Purpose.LENGTH)
    private ModifiableInteger compressionLength;
    @ModifiableVariableProperty(purpose=ModifiableVariableProperty.Purpose.LENGTH)
    private ModifiableInteger cipherSuiteLength;
    @ModifiableVariableProperty
    private ModifiableByteArray cipherSuites;
    @ModifiableVariableProperty
    private ModifiableByteArray compressions;
    @ModifiableVariableProperty
    private ModifiableByteArray cookie;
    @ModifiableVariableProperty(purpose=ModifiableVariableProperty.Purpose.LENGTH)
    private ModifiableInteger cookieLength;

    public CoreClientHelloMessage() {
        super(HandshakeMessageType.CLIENT_HELLO);
    }

    public CoreClientHelloMessage(Config tlsConfig) {
        super(HandshakeMessageType.CLIENT_HELLO);
        if (!tlsConfig.getHighestProtocolVersion().isSSL() || tlsConfig.getHighestProtocolVersion().isSSL() && tlsConfig.isAddExtensionsInSSL().booleanValue()) {
            if (tlsConfig.isAddHeartbeatExtension().booleanValue()) {
                this.addExtension(new HeartbeatExtensionMessage());
            }
            if (tlsConfig.isAddECPointFormatExtension().booleanValue()) {
                this.addExtension(new ECPointFormatExtensionMessage());
            }
            if (tlsConfig.isAddEllipticCurveExtension().booleanValue()) {
                this.addExtension(new EllipticCurvesExtensionMessage());
            }
            if (tlsConfig.isAddMaxFragmentLengthExtension().booleanValue()) {
                this.addExtension(new MaxFragmentLengthExtensionMessage());
            }
            if (tlsConfig.isAddRecordSizeLimitExtension().booleanValue()) {
                this.addExtension(new RecordSizeLimitExtensionMessage());
            }
            if (tlsConfig.isAddServerNameIndicationExtension().booleanValue()) {
                ServerNameIndicationExtensionMessage extension = new ServerNameIndicationExtensionMessage();
                this.addExtension(extension);
            }
            if (tlsConfig.isAddEncryptedServerNameIndicationExtension().booleanValue()) {
                byte[] serverName;
                EncryptedServerNameIndicationExtensionMessage extensionMessage = new EncryptedServerNameIndicationExtensionMessage();
                if (tlsConfig.getDefaultClientConnection().getHostname() != null) {
                    serverName = tlsConfig.getDefaultClientConnection().getHostname().getBytes(StandardCharsets.US_ASCII);
                } else {
                    LOGGER.warn("SNI not correctly configured!");
                    serverName = new byte[]{};
                }
                ServerNamePair pair = new ServerNamePair(tlsConfig.getSniType().getValue(), serverName);
                extensionMessage.getClientEsniInner().getServerNameList().add(pair);
                this.addExtension(extensionMessage);
            }
            if (tlsConfig.isAddSignatureAndHashAlgorithmsExtension().booleanValue()) {
                this.addExtension(new SignatureAndHashAlgorithmsExtensionMessage());
            }
            if (tlsConfig.isAddSignatureAlgorithmsCertExtension().booleanValue()) {
                this.addExtension(new SignatureAlgorithmsCertExtensionMessage());
            }
            if (tlsConfig.isAddSupportedVersionsExtension().booleanValue()) {
                this.addExtension(new SupportedVersionsExtensionMessage());
            }
            if (tlsConfig.isAddKeyShareExtension().booleanValue()) {
                this.addExtension(new KeyShareExtensionMessage(tlsConfig));
            }
            if (tlsConfig.isAddEarlyDataExtension().booleanValue()) {
                this.addExtension(new EarlyDataExtensionMessage());
            }
            if (tlsConfig.isAddDebugExtension().booleanValue()) {
                this.addExtension(new DebugExtensionMessage());
            }
            if (tlsConfig.isAddPSKKeyExchangeModesExtension().booleanValue()) {
                this.addExtension(new PSKKeyExchangeModesExtensionMessage(tlsConfig));
            }
            if (tlsConfig.isAddExtendedMasterSecretExtension().booleanValue()) {
                this.addExtension(new ExtendedMasterSecretExtensionMessage());
            }
            if (tlsConfig.isAddSessionTicketTLSExtension().booleanValue()) {
                this.addExtension(new SessionTicketTLSExtensionMessage());
            }
            if (tlsConfig.isAddSignedCertificateTimestampExtension().booleanValue()) {
                this.addExtension(new SignedCertificateTimestampExtensionMessage());
            }
            if (tlsConfig.isAddPaddingExtension().booleanValue()) {
                this.addExtension(new PaddingExtensionMessage());
            }
            if (tlsConfig.isAddRenegotiationInfoExtension().booleanValue()) {
                this.addExtension(new RenegotiationInfoExtensionMessage());
            }
            if (tlsConfig.isAddTokenBindingExtension().booleanValue()) {
                this.addExtension(new TokenBindingExtensionMessage());
            }
            if (tlsConfig.isAddCertificateStatusRequestExtension().booleanValue()) {
                this.addExtension(new CertificateStatusRequestExtensionMessage());
            }
            if (tlsConfig.isAddAlpnExtension().booleanValue()) {
                this.addExtension(new AlpnExtensionMessage());
            }
            if (tlsConfig.isAddSRPExtension().booleanValue()) {
                this.addExtension(new SRPExtensionMessage());
            }
            if (tlsConfig.isAddSRTPExtension().booleanValue()) {
                this.addExtension(new SrtpExtensionMessage());
            }
            if (tlsConfig.isAddTruncatedHmacExtension().booleanValue()) {
                this.addExtension(new TruncatedHmacExtensionMessage());
            }
            if (tlsConfig.isAddUserMappingExtension().booleanValue()) {
                this.addExtension(new UserMappingExtensionMessage());
            }
            if (tlsConfig.isAddCertificateTypeExtension().booleanValue()) {
                this.addExtension(new CertificateTypeExtensionMessage());
            }
            if (tlsConfig.isAddClientAuthzExtension().booleanValue()) {
                this.addExtension(new ClientAuthzExtensionMessage());
            }
            if (tlsConfig.isAddServerAuthzExtension().booleanValue()) {
                this.addExtension(new ServerAuthzExtensionMessage());
            }
            if (tlsConfig.isAddClientCertificateTypeExtension().booleanValue()) {
                this.addExtension(new ClientCertificateTypeExtensionMessage());
            }
            if (tlsConfig.isAddServerCertificateTypeExtension().booleanValue()) {
                this.addExtension(new ServerCertificateTypeExtensionMessage());
            }
            if (tlsConfig.isAddEncryptThenMacExtension().booleanValue()) {
                this.addExtension(new EncryptThenMacExtensionMessage());
            }
            if (tlsConfig.isAddCachedInfoExtension().booleanValue()) {
                this.addExtension(new CachedInfoExtensionMessage());
            }
            if (tlsConfig.isAddClientCertificateUrlExtension().booleanValue()) {
                this.addExtension(new ClientCertificateUrlExtensionMessage());
            }
            if (tlsConfig.isAddTrustedCaIndicationExtension().booleanValue()) {
                this.addExtension(new TrustedCaIndicationExtensionMessage());
            }
            if (tlsConfig.isAddCertificateStatusRequestV2Extension().booleanValue()) {
                this.addExtension(new CertificateStatusRequestV2ExtensionMessage());
            }
            if (tlsConfig.isAddPWDProtectExtension().booleanValue()) {
                this.addExtension(new PWDProtectExtensionMessage());
            }
            if (tlsConfig.isAddPWDClearExtension().booleanValue()) {
                this.addExtension(new PWDClearExtensionMessage());
            }
            if (tlsConfig.isAddExtendedRandomExtension().booleanValue()) {
                this.addExtension(new ExtendedRandomExtensionMessage());
            }
            if (tlsConfig.isAddCookieExtension().booleanValue()) {
                this.addExtension(new CookieExtensionMessage());
            }
            if (tlsConfig.isAddConnectionIdExtension().booleanValue()) {
                this.addExtension(new ConnectionIdExtensionMessage());
            }
            if (tlsConfig.isAddQuicTransportParametersExtension().booleanValue()) {
                this.addExtension(new QuicTransportParametersExtensionMessage(tlsConfig));
            }
            if (tlsConfig.isAddPreSharedKeyExtension().booleanValue()) {
                this.addExtension(new PreSharedKeyExtensionMessage(tlsConfig));
            }
        }
    }

    public ModifiableInteger getCompressionLength() {
        return this.compressionLength;
    }

    public ModifiableInteger getCipherSuiteLength() {
        return this.cipherSuiteLength;
    }

    public ModifiableByteArray getCipherSuites() {
        return this.cipherSuites;
    }

    public ModifiableByteArray getCompressions() {
        return this.compressions;
    }

    public void setCompressionLength(ModifiableInteger compressionLength) {
        this.compressionLength = compressionLength;
    }

    public void setCompressionLength(int compressionLength) {
        this.compressionLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.compressionLength, (Integer)compressionLength);
    }

    public void setCipherSuiteLength(ModifiableInteger cipherSuiteLength) {
        this.cipherSuiteLength = cipherSuiteLength;
    }

    public void setCipherSuiteLength(int cipherSuiteLength) {
        this.cipherSuiteLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.cipherSuiteLength, (Integer)cipherSuiteLength);
    }

    public void setCipherSuites(ModifiableByteArray cipherSuites) {
        this.cipherSuites = cipherSuites;
    }

    public void setCipherSuites(byte[] array) {
        this.cipherSuites = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.cipherSuites, (byte[])array);
    }

    public void setCompressions(ModifiableByteArray compressions) {
        this.compressions = compressions;
    }

    public void setCompressions(byte[] array) {
        this.compressions = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.compressions, (byte[])array);
    }

    public ModifiableByteArray getCookie() {
        return this.cookie;
    }

    public ModifiableInteger getCookieLength() {
        return this.cookieLength;
    }

    public void setCookie(byte[] cookie) {
        this.cookie = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.cookie, (byte[])cookie);
    }

    public void setCookie(ModifiableByteArray cookie) {
        this.cookie = cookie;
    }

    public void setCookieLength(int cookieLength) {
        this.cookieLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.cookieLength, (Integer)cookieLength);
    }

    public void setCookieLength(ModifiableInteger cookieLength) {
        this.cookieLength = cookieLength;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ClientHelloMessage:");
        sb.append("\n  Protocol Version: ");
        if (this.getProtocolVersion() != null && this.getProtocolVersion().getValue() != null) {
            sb.append((Object)ProtocolVersion.getProtocolVersion((byte[])this.getProtocolVersion().getValue()));
        } else {
            sb.append("null");
        }
        sb.append("\n  Client Unix Time: ");
        if (this.getUnixTime() != null && this.getUnixTime().getValue() != null) {
            sb.append(new Date(DataConverter.bytesToLong((byte[])((byte[])this.getUnixTime().getValue())) * 1000L));
        } else {
            sb.append("null");
        }
        sb.append("\n  Client Random: ");
        if (this.getRandom() != null && this.getRandom().getValue() != null) {
            sb.append(DataConverter.bytesToRawHexString((byte[])((byte[])this.getRandom().getValue())));
        } else {
            sb.append("null");
        }
        sb.append("\n  Session ID: ");
        if (this.getSessionId() != null && this.getSessionId().getValue() != null) {
            sb.append(DataConverter.bytesToRawHexString((byte[])((byte[])this.getSessionId().getValue())));
        } else {
            sb.append("null");
        }
        sb.append("\n  Supported Cipher Suites: ");
        if (this.getCipherSuites() != null && this.getCipherSuites().getValue() != null) {
            sb.append(DataConverter.bytesToRawHexString((byte[])((byte[])this.getCipherSuites().getValue())));
        } else {
            sb.append("null");
        }
        sb.append("\n  Supported Compression Methods: ");
        if (this.getCompressions() != null && this.getCompressions().getValue() != null) {
            sb.append(DataConverter.bytesToRawHexString((byte[])((byte[])this.getCompressions().getValue())));
        } else {
            sb.append("null");
        }
        sb.append("\n  Extensions: ");
        if (this.getExtensions() != null) {
            for (ExtensionMessage extension : this.getExtensions()) {
                sb.append(extension.toString()).append("\n");
            }
        } else {
            sb.append("null");
        }
        return sb.toString();
    }

    @Override
    public String toShortString() {
        return "CH";
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + Objects.hashCode(this.compressionLength);
        hash = 97 * hash + Objects.hashCode(this.cipherSuiteLength);
        hash = 97 * hash + Objects.hashCode(this.cipherSuites);
        hash = 97 * hash + Objects.hashCode(this.compressions);
        hash = 97 * hash + Objects.hashCode(this.cookie);
        hash = 97 * hash + Objects.hashCode(this.cookieLength);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CoreClientHelloMessage other = (CoreClientHelloMessage)obj;
        if (!Objects.equals(this.compressionLength, other.compressionLength)) {
            return false;
        }
        if (!Objects.equals(this.cipherSuiteLength, other.cipherSuiteLength)) {
            return false;
        }
        if (!Objects.equals(this.cipherSuites, other.cipherSuites)) {
            return false;
        }
        if (!Objects.equals(this.compressions, other.compressions)) {
            return false;
        }
        if (!Objects.equals(this.cookie, other.cookie)) {
            return false;
        }
        return Objects.equals(this.cookieLength, other.cookieLength);
    }
}

