/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message;

import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.protocol.handler.EncryptedExtensionsHandler;
import de.rub.nds.tlsattacker.core.protocol.message.HandshakeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.RecordSizeLimitExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.EncryptedExtensionsParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.EncryptedExtensionsPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.EncryptedExtensionsSerializer;
import de.rub.nds.tlsattacker.core.state.Context;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

@XmlRootElement(name="EncryptedExtensions")
public class EncryptedExtensionsMessage
extends HandshakeMessage {
    public EncryptedExtensionsMessage() {
        super(HandshakeMessageType.ENCRYPTED_EXTENSIONS);
    }

    public EncryptedExtensionsMessage(Config config) {
        super(HandshakeMessageType.ENCRYPTED_EXTENSIONS);
        if (!config.isRespectClientProposedExtensions().booleanValue()) {
            this.createConfiguredExtensions(config).forEach(this::addExtension);
        }
    }

    @Override
    public final List<ExtensionMessage> createConfiguredExtensions(Config config) {
        LinkedList<ExtensionMessage> configuredExtensions = new LinkedList<ExtensionMessage>();
        if (config.isAddRecordSizeLimitExtension().booleanValue()) {
            configuredExtensions.add(new RecordSizeLimitExtensionMessage());
        }
        return configuredExtensions;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("EncryptedExtensionMessage:");
        sb.append("\n  Extensions: ");
        if (this.getExtensions() == null) {
            sb.append("null");
        } else {
            for (ExtensionMessage e : this.getExtensions()) {
                sb.append(e.toString());
            }
        }
        return sb.toString();
    }

    @Override
    public String toShortString() {
        return "EEM";
    }

    @Override
    public EncryptedExtensionsHandler getHandler(Context context) {
        return new EncryptedExtensionsHandler(context.getTlsContext());
    }

    @Override
    public EncryptedExtensionsParser getParser(Context context, InputStream stream) {
        return new EncryptedExtensionsParser(stream, context.getTlsContext());
    }

    @Override
    public EncryptedExtensionsPreparator getPreparator(Context context) {
        return new EncryptedExtensionsPreparator(context.getChooser(), this);
    }

    @Override
    public EncryptedExtensionsSerializer getSerializer(Context context) {
        return new EncryptedExtensionsSerializer(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EncryptedExtensionsMessage other = (EncryptedExtensionsMessage)obj;
        return Objects.equals(this.getExtensions(), other.getExtensions());
    }

    public int hashCode() {
        int hash = 7;
        return hash;
    }
}

