/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message;

import de.rub.nds.protocol.util.SilentByteArrayOutputStream;
import de.rub.nds.tlsattacker.core.protocol.ProtocolMessage;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class MessageIO {
    private static final Logger LOGGER = LogManager.getLogger();
    private static JAXBContext context;

    private static synchronized JAXBContext getJAXBContext() throws JAXBException {
        if (context == null) {
            Reflections reflections = new Reflections("de.rub.nds.tlsattacker.core.protocol.message", new Scanner[0]);
            Set classes = reflections.getSubTypesOf(ProtocolMessage.class);
            reflections = new Reflections("de.rub.nds.tlsattacker.core.https", new Scanner[0]);
            classes.addAll(reflections.getSubTypesOf(ProtocolMessage.class));
            Class[] classesArray = classes.toArray(new Class[classes.size()]);
            context = JAXBContext.newInstance((Class[])classesArray);
        }
        return context;
    }

    public static void write(File file, ProtocolMessage message) throws JAXBException, IOException {
        assert (file.exists() || file.createNewFile());
        try (FileOutputStream fos = new FileOutputStream(file);){
            MessageIO.write(fos, message);
        }
    }

    public static void write(OutputStream outputStream, ProtocolMessage message) throws JAXBException, IOException {
        context = MessageIO.getJAXBContext();
        Marshaller m = context.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)true);
        m.marshal((Object)message, outputStream);
    }

    public static ProtocolMessage read(InputStream inputStream) throws JAXBException, IOException, XMLStreamException {
        context = MessageIO.getJAXBContext();
        Unmarshaller m = context.createUnmarshaller();
        XMLInputFactory xif = XMLInputFactory.newFactory();
        xif.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        xif.setProperty("javax.xml.stream.supportDTD", false);
        XMLStreamReader xsr = xif.createXMLStreamReader(inputStream);
        return (ProtocolMessage)m.unmarshal(xsr);
    }

    public static ProtocolMessage copyTlsAction(ProtocolMessage message) throws JAXBException, IOException, XMLStreamException {
        SilentByteArrayOutputStream stream = new SilentByteArrayOutputStream();
        MessageIO.write((OutputStream)stream, message);
        stream.flush();
        return MessageIO.read(new ByteArrayInputStream(stream.toByteArray()));
    }

    private MessageIO() {
    }
}

