/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message;

import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.integer.ModifiableInteger;
import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.tlsattacker.core.protocol.handler.PskDhClientKeyExchangeHandler;
import de.rub.nds.tlsattacker.core.protocol.message.DHClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.PskDhClientKeyExchangeParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.PskDhClientKeyExchangePreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.PskDhClientKeyExchangeSerializer;
import de.rub.nds.tlsattacker.core.state.Context;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.InputStream;

@XmlRootElement(name="PskDhClientKeyExchange")
public class PskDhClientKeyExchangeMessage
extends DHClientKeyExchangeMessage {
    @ModifiableVariableProperty
    private ModifiableByteArray identity;
    @ModifiableVariableProperty(purpose=ModifiableVariableProperty.Purpose.LENGTH)
    private ModifiableInteger identityLength;

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PskDhClientKeyExchangeMessage:");
        sb.append("\n  PSKIdentity Length: ");
        if (this.identityLength != null && this.identityLength.getValue() != null) {
            sb.append(this.identityLength.getValue());
        } else {
            sb.append("null");
        }
        sb.append("\n  PSKIdentity: ");
        if (this.identity != null && this.identity.getValue() != null) {
            sb.append(DataConverter.bytesToHexString((byte[])((byte[])this.identity.getValue())));
        } else {
            sb.append("null");
        }
        return sb.toString();
    }

    public ModifiableByteArray getIdentity() {
        return this.identity;
    }

    public void setIdentity(ModifiableByteArray identity) {
        this.identity = identity;
    }

    public void setIdentity(byte[] identity) {
        this.identity = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.identity, (byte[])identity);
    }

    public ModifiableInteger getIdentityLength() {
        return this.identityLength;
    }

    public void setIdentityLength(ModifiableInteger identityLength) {
        this.identityLength = identityLength;
    }

    public void setIdentityLength(int identityLength) {
        this.identityLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.identityLength, (Integer)identityLength);
    }

    @Override
    public PskDhClientKeyExchangeHandler getHandler(Context context) {
        return new PskDhClientKeyExchangeHandler(context.getTlsContext());
    }

    @Override
    public PskDhClientKeyExchangeParser getParser(Context context, InputStream stream) {
        return new PskDhClientKeyExchangeParser(stream, context.getTlsContext());
    }

    @Override
    public PskDhClientKeyExchangePreparator getPreparator(Context context) {
        return new PskDhClientKeyExchangePreparator(context.getChooser(), this);
    }

    @Override
    public PskDhClientKeyExchangeSerializer getSerializer(Context context) {
        return new PskDhClientKeyExchangeSerializer(this);
    }

    @Override
    public String toCompactString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PSK_DH_CLIENT_KEY_EXCHANGE");
        if (this.isRetransmission()) {
            sb.append(" (ret.)");
        }
        return sb.toString();
    }

    @Override
    public String toShortString() {
        return "PSK_DH_CKE";
    }
}

