/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message;

import de.rub.nds.modifiablevariable.HoldsModifiableVariable;
import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableHolder;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.integer.ModifiableInteger;
import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.tlsattacker.core.protocol.handler.PskServerKeyExchangeHandler;
import de.rub.nds.tlsattacker.core.protocol.message.ServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.computations.PSKPremasterComputations;
import de.rub.nds.tlsattacker.core.protocol.parser.PskServerKeyExchangeParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.PskServerKeyExchangePreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.PskServerKeyExchangeSerializer;
import de.rub.nds.tlsattacker.core.state.Context;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.InputStream;
import java.util.List;

@XmlRootElement(name="PskServerKeyExchange")
public class PskServerKeyExchangeMessage
extends ServerKeyExchangeMessage {
    @HoldsModifiableVariable
    protected PSKPremasterComputations computations;
    private ModifiableByteArray identityHint;
    @ModifiableVariableProperty(purpose=ModifiableVariableProperty.Purpose.LENGTH)
    private ModifiableInteger identityHintLength;

    public ModifiableByteArray getIdentityHint() {
        return this.identityHint;
    }

    public void setIdentityHint(ModifiableByteArray identityHint) {
        this.identityHint = identityHint;
    }

    public void setIdentityHint(byte[] identity) {
        this.identityHint = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.identityHint, (byte[])identity);
    }

    public ModifiableInteger getIdentityHintLength() {
        return this.identityHintLength;
    }

    public void setIdentityHintLength(ModifiableInteger identityHintLength) {
        this.identityHintLength = identityHintLength;
    }

    public void setIdentityHintLength(int identityHintLength) {
        this.identityHintLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.identityHintLength, (Integer)identityHintLength);
    }

    @Override
    public PSKPremasterComputations getKeyExchangeComputations() {
        return this.computations;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PskServerKeyExchangeMessage:");
        sb.append("\n  IdentityHintLength: ");
        if (this.identityHintLength != null && this.identityHintLength.getValue() != null) {
            sb.append(this.identityHintLength.getValue());
        } else {
            sb.append("null");
        }
        sb.append("\n  IdentityHint: ");
        if (this.identityHint != null && this.identityHint.getValue() != null) {
            sb.append(DataConverter.bytesToHexString((byte[])((byte[])this.identityHint.getValue())));
        } else {
            sb.append("null");
        }
        return sb.toString();
    }

    @Override
    public PskServerKeyExchangeHandler getHandler(Context context) {
        return new PskServerKeyExchangeHandler(context.getTlsContext());
    }

    @Override
    public PskServerKeyExchangeParser getParser(Context context, InputStream stream) {
        return new PskServerKeyExchangeParser(stream, context.getTlsContext());
    }

    @Override
    public PskServerKeyExchangePreparator getPreparator(Context context) {
        return new PskServerKeyExchangePreparator(context.getChooser(), this);
    }

    @Override
    public PskServerKeyExchangeSerializer getSerializer(Context context) {
        return new PskServerKeyExchangeSerializer(this, context.getChooser().getSelectedProtocolVersion());
    }

    @Override
    public String toCompactString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PSK_SERVER_KEY_EXCHANGE");
        if (this.isRetransmission()) {
            sb.append(" (ret.)");
        }
        return sb.toString();
    }

    @Override
    public void prepareKeyExchangeComputations() {
        if (this.getKeyExchangeComputations() == null) {
            this.computations = new PSKPremasterComputations();
        }
    }

    @Override
    public List<ModifiableVariableHolder> getAllModifiableVariableHolders() {
        List<ModifiableVariableHolder> holders = super.getAllModifiableVariableHolders();
        if (this.computations != null) {
            holders.add(this.computations);
        }
        return holders;
    }

    @Override
    public String toShortString() {
        return "PSK_SKE";
    }
}

