/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message;

import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.integer.ModifiableInteger;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.protocol.handler.RequestConnectionIdHandler;
import de.rub.nds.tlsattacker.core.protocol.message.HandshakeMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.RequestConnectionIdParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.RequestConnectionIdPreperator;
import de.rub.nds.tlsattacker.core.protocol.serializer.RequestConnectionIdSerializer;
import de.rub.nds.tlsattacker.core.state.Context;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.InputStream;
import java.util.Objects;

@XmlRootElement(name="RequestConnectionId")
public class RequestConnectionIdMessage
extends HandshakeMessage {
    @ModifiableVariableProperty
    private ModifiableInteger numberOfConnectionIds;

    public RequestConnectionIdMessage() {
        super(HandshakeMessageType.REQUEST_CONNECTION_ID);
    }

    public ModifiableInteger getNumberOfConnectionIds() {
        return this.numberOfConnectionIds;
    }

    public void setNumberOfConnectionIds(ModifiableInteger numberOfConnectionIds) {
        this.numberOfConnectionIds = numberOfConnectionIds;
    }

    public void setNumberOfConnectionIds(Integer numberOfConnectionIds) {
        this.numberOfConnectionIds = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.numberOfConnectionIds, (Integer)numberOfConnectionIds);
    }

    @Override
    public RequestConnectionIdParser getParser(Context context, InputStream stream) {
        return new RequestConnectionIdParser(stream, context.getTlsContext());
    }

    @Override
    public RequestConnectionIdPreperator getPreparator(Context context) {
        return new RequestConnectionIdPreperator(context.getChooser(), this);
    }

    @Override
    public RequestConnectionIdSerializer getSerializer(Context context) {
        return new RequestConnectionIdSerializer(this);
    }

    @Override
    public RequestConnectionIdHandler getHandler(Context context) {
        return new RequestConnectionIdHandler(context.getTlsContext());
    }

    public int hashCode() {
        int hash = 3;
        hash = 67 * hash + Objects.hashCode(this.numberOfConnectionIds);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RequestConnectionIdMessage other = (RequestConnectionIdMessage)obj;
        return Objects.equals(this.numberOfConnectionIds, other.numberOfConnectionIds);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RequestConnectionId: \n");
        sb.append("\t NumberOfConnectionIds: ");
        if (this.numberOfConnectionIds != null && this.numberOfConnectionIds.getValue() != null) {
            sb.append(this.numberOfConnectionIds.getValue());
        } else {
            sb.append("null");
        }
        return sb.toString();
    }

    @Override
    public String toShortString() {
        return "RCID";
    }
}

