/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message;

import de.rub.nds.modifiablevariable.HoldsModifiableVariable;
import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableHolder;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.integer.ModifiableInteger;
import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.tlsattacker.core.constants.SSL2MessageType;
import de.rub.nds.tlsattacker.core.protocol.handler.SSL2ClientMasterKeyHandler;
import de.rub.nds.tlsattacker.core.protocol.message.SSL2Message;
import de.rub.nds.tlsattacker.core.protocol.message.computations.RSAClientComputations;
import de.rub.nds.tlsattacker.core.protocol.parser.SSL2MessageParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.SSL2ClientMasterKeyPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.SSL2ClientMasterKeySerializer;
import de.rub.nds.tlsattacker.core.state.Context;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;

@XmlRootElement(name="SSL2ClientMasterKey")
public class SSL2ClientMasterKeyMessage
extends SSL2Message {
    @ModifiableVariableProperty
    private ModifiableByteArray cipherKind;
    @ModifiableVariableProperty(purpose=ModifiableVariableProperty.Purpose.LENGTH)
    private ModifiableInteger clearKeyLength;
    @ModifiableVariableProperty(purpose=ModifiableVariableProperty.Purpose.LENGTH)
    private ModifiableInteger encryptedKeyLength;
    @ModifiableVariableProperty(purpose=ModifiableVariableProperty.Purpose.LENGTH)
    private ModifiableInteger keyArgLength;
    @ModifiableVariableProperty
    private ModifiableByteArray clearKeyData;
    @ModifiableVariableProperty
    private ModifiableByteArray encryptedKeyData;
    @ModifiableVariableProperty
    private ModifiableByteArray keyArgData;
    @HoldsModifiableVariable
    @XmlElement
    private RSAClientComputations computations;

    public SSL2ClientMasterKeyMessage() {
        super(SSL2MessageType.SSL_CLIENT_MASTER_KEY);
    }

    @Override
    public String toCompactString() {
        return "SSL2 ClientMasterKey Message";
    }

    @Override
    public SSL2ClientMasterKeyHandler getHandler(Context context) {
        return new SSL2ClientMasterKeyHandler(context.getTlsContext());
    }

    @Override
    public SSL2MessageParser<SSL2ClientMasterKeyMessage> getParser(Context context, InputStream stream) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public SSL2ClientMasterKeyPreparator getPreparator(Context context) {
        return new SSL2ClientMasterKeyPreparator(context.getChooser(), this);
    }

    @Override
    public SSL2ClientMasterKeySerializer getSerializer(Context context) {
        return new SSL2ClientMasterKeySerializer(this);
    }

    public ModifiableByteArray getCipherKind() {
        return this.cipherKind;
    }

    public void setCipherKind(ModifiableByteArray cipherKind) {
        this.cipherKind = cipherKind;
    }

    public void setCipherKind(byte[] cipherKind) {
        this.cipherKind = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.cipherKind, (byte[])cipherKind);
    }

    public ModifiableInteger getClearKeyLength() {
        return this.clearKeyLength;
    }

    public void setClearKeyLength(int clearKeyLength) {
        this.clearKeyLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.clearKeyLength, (Integer)clearKeyLength);
    }

    public void setClearKeyLength(ModifiableInteger clearKeyLength) {
        this.clearKeyLength = clearKeyLength;
    }

    public ModifiableInteger getEncryptedKeyLength() {
        return this.encryptedKeyLength;
    }

    public void setEncryptedKeyLength(int encryptedKeyLength) {
        this.encryptedKeyLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.encryptedKeyLength, (Integer)encryptedKeyLength);
    }

    public void setEncryptedKeyLength(ModifiableInteger encryptedKeyLength) {
        this.encryptedKeyLength = encryptedKeyLength;
    }

    public ModifiableInteger getKeyArgLength() {
        return this.keyArgLength;
    }

    public void setKeyArgLength(int keyArgLength) {
        this.keyArgLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.keyArgLength, (Integer)keyArgLength);
    }

    public void setKeyArgLength(ModifiableInteger keyArgLength) {
        this.keyArgLength = keyArgLength;
    }

    public ModifiableByteArray getClearKeyData() {
        return this.clearKeyData;
    }

    public void setClearKeyData(ModifiableByteArray clearKeyData) {
        this.clearKeyData = clearKeyData;
    }

    public void setClearKeyData(byte[] clearKeyData) {
        this.clearKeyData = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.clearKeyData, (byte[])clearKeyData);
    }

    public ModifiableByteArray getEncryptedKeyData() {
        return this.encryptedKeyData;
    }

    public void setEncryptedKeyData(ModifiableByteArray encryptedKeyData) {
        this.encryptedKeyData = encryptedKeyData;
    }

    public void setEncryptedKeyData(byte[] encryptedKeyData) {
        this.encryptedKeyData = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.encryptedKeyData, (byte[])encryptedKeyData);
    }

    public ModifiableByteArray getKeyArgData() {
        return this.keyArgData;
    }

    public void setKeyArgData(ModifiableByteArray keyArgData) {
        this.keyArgData = keyArgData;
    }

    public void setKeyArgData(byte[] keyArgData) {
        this.keyArgData = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.keyArgData, (byte[])keyArgData);
    }

    public void prepareComputations() {
        if (this.computations == null) {
            this.computations = new RSAClientComputations();
        }
    }

    public RSAClientComputations getComputations() {
        return this.computations;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        if (this.getCipherKind() != null && this.getCipherKind().getValue() != null) {
            sb.append("\n Cipher Kind: ").append(this.getCipherKind().getValue());
        }
        if (this.getClearKeyData() != null && this.getClearKeyData().getValue() != null) {
            sb.append("\n Clear Key Data: ").append(DataConverter.bytesToHexString((byte[])((byte[])this.getClearKeyData().getValue())));
        }
        if (this.getEncryptedKeyData() != null && this.getEncryptedKeyData().getValue() != null) {
            sb.append("\n Encrypted Key Data: ").append(DataConverter.bytesToHexString((byte[])((byte[])this.getEncryptedKeyData().getValue())));
        }
        if (this.getKeyArgData() != null && this.getKeyArgData().getValue() != null) {
            sb.append("\n Key Arg Data: ").append(DataConverter.bytesToHexString((byte[])((byte[])this.getKeyArgData().getValue())));
        }
        return sb.toString();
    }

    @Override
    public String toShortString() {
        return "SSL2_CMKM";
    }

    public List<ModifiableVariableHolder> getAllModifiableVariableHolders() {
        List allModifiableVariableHolders = super.getAllModifiableVariableHolders();
        if (this.computations != null) {
            allModifiableVariableHolders.add(this.computations);
        }
        return allModifiableVariableHolders;
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + Objects.hashCode(this.cipherKind);
        hash = 29 * hash + Objects.hashCode(this.clearKeyLength);
        hash = 29 * hash + Objects.hashCode(this.encryptedKeyLength);
        hash = 29 * hash + Objects.hashCode(this.keyArgLength);
        hash = 29 * hash + Objects.hashCode(this.clearKeyData);
        hash = 29 * hash + Objects.hashCode(this.encryptedKeyData);
        hash = 29 * hash + Objects.hashCode(this.keyArgData);
        hash = 29 * hash + Objects.hashCode((Object)this.computations);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SSL2ClientMasterKeyMessage other = (SSL2ClientMasterKeyMessage)obj;
        if (!Objects.equals(this.cipherKind, other.cipherKind)) {
            return false;
        }
        if (!Objects.equals(this.clearKeyLength, other.clearKeyLength)) {
            return false;
        }
        if (!Objects.equals(this.encryptedKeyLength, other.encryptedKeyLength)) {
            return false;
        }
        if (!Objects.equals(this.keyArgLength, other.keyArgLength)) {
            return false;
        }
        if (!Objects.equals(this.clearKeyData, other.clearKeyData)) {
            return false;
        }
        if (!Objects.equals(this.encryptedKeyData, other.encryptedKeyData)) {
            return false;
        }
        if (!Objects.equals(this.keyArgData, other.keyArgData)) {
            return false;
        }
        return Objects.equals((Object)this.computations, (Object)other.computations);
    }
}

