/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message;

import de.rub.nds.modifiablevariable.HoldsModifiableVariable;
import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.integer.ModifiableInteger;
import de.rub.nds.protocol.constants.SignatureAlgorithm;
import de.rub.nds.protocol.crypto.signature.SignatureCalculator;
import de.rub.nds.protocol.crypto.signature.SignatureComputations;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.protocol.message.HandshakeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.computations.KeyExchangeComputations;
import java.util.Objects;

public abstract class ServerKeyExchangeMessage
extends HandshakeMessage {
    @ModifiableVariableProperty
    private ModifiableByteArray signatureAndHashAlgorithm;
    @ModifiableVariableProperty(purpose=ModifiableVariableProperty.Purpose.LENGTH)
    private ModifiableInteger signatureLength;
    @ModifiableVariableProperty
    private ModifiableByteArray signature;
    @ModifiableVariableProperty(purpose=ModifiableVariableProperty.Purpose.LENGTH)
    private ModifiableInteger publicKeyLength;
    @ModifiableVariableProperty
    private ModifiableByteArray publicKey;
    @HoldsModifiableVariable
    private SignatureComputations signatureComputations;

    public ServerKeyExchangeMessage() {
        super(HandshakeMessageType.SERVER_KEY_EXCHANGE);
    }

    public abstract KeyExchangeComputations getKeyExchangeComputations();

    public abstract void prepareKeyExchangeComputations();

    public SignatureComputations getSignatureComputations(SignatureAlgorithm algorithm) {
        if (this.signatureComputations == null) {
            SignatureCalculator calculator = new SignatureCalculator();
            this.signatureComputations = calculator.createSignatureComputations(algorithm);
        }
        return this.signatureComputations;
    }

    public ModifiableByteArray getSignatureAndHashAlgorithm() {
        return this.signatureAndHashAlgorithm;
    }

    public void setSignatureAndHashAlgorithm(ModifiableByteArray signatureAndHashAlgorithm) {
        this.signatureAndHashAlgorithm = signatureAndHashAlgorithm;
    }

    public void setSignatureAndHashAlgorithm(byte[] signatureAndHashAlgorithm) {
        this.signatureAndHashAlgorithm = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.signatureAndHashAlgorithm, (byte[])signatureAndHashAlgorithm);
    }

    public ModifiableInteger getSignatureLength() {
        return this.signatureLength;
    }

    public void setSignatureLength(ModifiableInteger signatureLength) {
        this.signatureLength = signatureLength;
    }

    public void setSignatureLength(int length) {
        this.signatureLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.signatureLength, (Integer)length);
    }

    public ModifiableByteArray getSignature() {
        return this.signature;
    }

    public void setSignature(ModifiableByteArray signature) {
        this.signature = signature;
    }

    public void setSignature(byte[] signature) {
        this.signature = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.signature, (byte[])signature);
    }

    public ModifiableInteger getPublicKeyLength() {
        return this.publicKeyLength;
    }

    public void setPublicKeyLength(ModifiableInteger publicKeyLength) {
        this.publicKeyLength = publicKeyLength;
    }

    public void setPublicKeyLength(Integer publicKeyLength) {
        this.publicKeyLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.publicKeyLength, (Integer)publicKeyLength);
    }

    public ModifiableByteArray getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(ModifiableByteArray publicKey) {
        this.publicKey = publicKey;
    }

    public void setPublicKey(byte[] publicKey) {
        this.publicKey = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.publicKey, (byte[])publicKey);
    }

    @Override
    public String toShortString() {
        return "SKE";
    }

    public int hashCode() {
        int hash = 7;
        hash = 83 * hash + Objects.hashCode(this.signatureAndHashAlgorithm);
        hash = 83 * hash + Objects.hashCode(this.signatureLength);
        hash = 83 * hash + Objects.hashCode(this.signature);
        hash = 83 * hash + Objects.hashCode(this.publicKeyLength);
        hash = 83 * hash + Objects.hashCode(this.publicKey);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServerKeyExchangeMessage other = (ServerKeyExchangeMessage)obj;
        if (!Objects.equals(this.signatureAndHashAlgorithm, other.signatureAndHashAlgorithm)) {
            return false;
        }
        if (!Objects.equals(this.signatureLength, other.signatureLength)) {
            return false;
        }
        if (!Objects.equals(this.signature, other.signature)) {
            return false;
        }
        if (!Objects.equals(this.publicKeyLength, other.publicKeyLength)) {
            return false;
        }
        return Objects.equals(this.publicKey, other.publicKey);
    }
}

