/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message.extension;

import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.integer.ModifiableInteger;
import de.rub.nds.tlsattacker.core.constants.ExtensionType;
import de.rub.nds.tlsattacker.core.protocol.handler.extension.EllipticCurvesExtensionHandler;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.EllipticCurvesExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.EllipticCurvesExtensionPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.EllipticCurvesExtensionSerializer;
import de.rub.nds.tlsattacker.core.state.Context;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.InputStream;

@XmlRootElement(name="EllipticCurves")
public class EllipticCurvesExtensionMessage
extends ExtensionMessage {
    @ModifiableVariableProperty(purpose=ModifiableVariableProperty.Purpose.LENGTH)
    private ModifiableInteger supportedGroupsLength;
    @ModifiableVariableProperty
    private ModifiableByteArray supportedGroups;

    public EllipticCurvesExtensionMessage() {
        super(ExtensionType.ELLIPTIC_CURVES);
    }

    public ModifiableInteger getSupportedGroupsLength() {
        return this.supportedGroupsLength;
    }

    public void setSupportedGroupsLength(int length) {
        this.supportedGroupsLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.supportedGroupsLength, (Integer)length);
    }

    public void setSupportedGroupsLength(ModifiableInteger supportedGroupsLength) {
        this.supportedGroupsLength = supportedGroupsLength;
    }

    public ModifiableByteArray getSupportedGroups() {
        return this.supportedGroups;
    }

    public void setSupportedGroups(byte[] array) {
        this.supportedGroups = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.supportedGroups, (byte[])array);
    }

    public void setSupportedGroups(ModifiableByteArray supportedGroups) {
        this.supportedGroups = supportedGroups;
    }

    @Override
    public EllipticCurvesExtensionParser getParser(Context context, InputStream stream) {
        return new EllipticCurvesExtensionParser(stream, context.getTlsContext());
    }

    @Override
    public EllipticCurvesExtensionPreparator getPreparator(Context context) {
        return new EllipticCurvesExtensionPreparator(context.getChooser(), this);
    }

    @Override
    public EllipticCurvesExtensionSerializer getSerializer(Context context) {
        return new EllipticCurvesExtensionSerializer(this);
    }

    @Override
    public EllipticCurvesExtensionHandler getHandler(Context context) {
        return new EllipticCurvesExtensionHandler(context.getTlsContext());
    }
}

