/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message.extension;

import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.tlsattacker.core.constants.ExtensionType;
import de.rub.nds.tlsattacker.core.protocol.handler.extension.GreaseExtensionHandler;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.GreaseExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.GreaseExtensionPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.GreaseExtensionSerializer;
import de.rub.nds.tlsattacker.core.state.Context;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@XmlRootElement(name="GreaseExtension")
public class GreaseExtensionMessage
extends ExtensionMessage {
    private static final Logger LOGGER = LogManager.getLogger();
    @ModifiableVariableProperty
    private ModifiableByteArray randomData;
    private byte[] data;
    private ExtensionType type;

    public GreaseExtensionMessage() {
        super(ExtensionType.GREASE_00);
        this.type = ExtensionType.GREASE_00;
        this.data = new byte[0];
    }

    public GreaseExtensionMessage(ExtensionType type, byte[] data) {
        super(type);
        if (!type.isGrease()) {
            LOGGER.warn("GreaseExtension message inizialized with non Grease extension type");
        }
        this.data = data;
        this.type = type;
    }

    public GreaseExtensionMessage(ExtensionType type, int length) {
        super(type);
        if (!type.isGrease()) {
            LOGGER.warn("GreaseExtension message inizialized with non Grease extension type");
        }
        byte[] b = new byte[length];
        this.data = b;
        this.type = type;
    }

    @Override
    public ExtensionType getExtensionTypeConstant() {
        return this.type;
    }

    public ModifiableByteArray getRandomData() {
        return this.randomData;
    }

    public void setRandomData(byte[] bytes) {
        this.randomData = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.randomData, (byte[])bytes);
    }

    public void setRandomData(ModifiableByteArray randomData) {
        this.randomData = randomData;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public ExtensionType getType() {
        return this.type;
    }

    public void setType(ExtensionType type) {
        if (!type.isGrease()) {
            LOGGER.warn("GreaseExtension message type was set to non Grease extension type");
        }
        this.type = type;
        this.extensionTypeConstant = type;
    }

    @Override
    public GreaseExtensionParser getParser(Context context, InputStream stream) {
        return new GreaseExtensionParser(stream, context.getTlsContext());
    }

    @Override
    public GreaseExtensionPreparator getPreparator(Context context) {
        return new GreaseExtensionPreparator(context.getChooser(), this);
    }

    @Override
    public GreaseExtensionSerializer getSerializer(Context context) {
        return new GreaseExtensionSerializer(this);
    }

    @Override
    public GreaseExtensionHandler getHandler(Context context) {
        return new GreaseExtensionHandler(context.getTlsContext());
    }
}

