/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message.extension;

import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.tlsattacker.core.constants.ExtensionType;
import de.rub.nds.tlsattacker.core.protocol.handler.extension.PaddingExtensionHandler;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.PaddingExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.PaddingExtensionPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.PaddingExtensionSerializer;
import de.rub.nds.tlsattacker.core.state.Context;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.InputStream;

@XmlRootElement(name="PaddingExtension")
public class PaddingExtensionMessage
extends ExtensionMessage {
    @ModifiableVariableProperty
    private ModifiableByteArray paddingBytes;

    public PaddingExtensionMessage() {
        super(ExtensionType.PADDING);
    }

    public ModifiableByteArray getPaddingBytes() {
        return this.paddingBytes;
    }

    public void setPaddingBytes(ModifiableByteArray paddingBytes) {
        this.paddingBytes = paddingBytes;
    }

    public void setPaddingBytes(byte[] array) {
        this.paddingBytes = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.paddingBytes, (byte[])array);
    }

    @Override
    public PaddingExtensionParser getParser(Context context, InputStream stream) {
        return new PaddingExtensionParser(stream, context.getTlsContext());
    }

    @Override
    public PaddingExtensionPreparator getPreparator(Context context) {
        return new PaddingExtensionPreparator(context.getChooser(), this);
    }

    @Override
    public PaddingExtensionSerializer getSerializer(Context context) {
        return new PaddingExtensionSerializer(this);
    }

    @Override
    public PaddingExtensionHandler getHandler(Context context) {
        return new PaddingExtensionHandler(context.getTlsContext());
    }
}

