/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message.extension;

import de.rub.nds.modifiablevariable.HoldsModifiableVariable;
import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableHolder;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.integer.ModifiableInteger;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.ExtensionType;
import de.rub.nds.tlsattacker.core.protocol.handler.extension.PreSharedKeyExtensionHandler;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.psk.PSKBinder;
import de.rub.nds.tlsattacker.core.protocol.message.extension.psk.PSKIdentity;
import de.rub.nds.tlsattacker.core.protocol.message.extension.psk.PskSet;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.PreSharedKeyExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.PreSharedKeyExtensionPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.PreSharedKeyExtensionSerializer;
import de.rub.nds.tlsattacker.core.state.Context;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;

@XmlRootElement(name="PreSharedKeyExtension")
public class PreSharedKeyExtensionMessage
extends ExtensionMessage {
    private ModifiableInteger identityListLength;
    private ModifiableInteger binderListLength;
    private ModifiableByteArray identityListBytes;
    private ModifiableByteArray binderListBytes;
    @HoldsModifiableVariable
    private List<PSKIdentity> identities;
    @HoldsModifiableVariable
    private List<PSKBinder> binders;
    private ModifiableInteger selectedIdentity;

    public PreSharedKeyExtensionMessage() {
        super(ExtensionType.PRE_SHARED_KEY);
        this.identities = new LinkedList<PSKIdentity>();
        this.binders = new LinkedList<PSKBinder>();
    }

    public PreSharedKeyExtensionMessage(Config config) {
        super(ExtensionType.PRE_SHARED_KEY);
        if (config.getDefaultPskSets().size() > 0) {
            this.copyPskSets(config.getDefaultPskSets(), config.isLimitPsksToOne());
        }
    }

    public List<PSKIdentity> getIdentities() {
        return this.identities;
    }

    public void setIdentities(List<PSKIdentity> identities) {
        this.identities = identities;
    }

    public List<PSKBinder> getBinders() {
        return this.binders;
    }

    public void setBinders(List<PSKBinder> binders) {
        this.binders = binders;
    }

    public ModifiableInteger getIdentityListLength() {
        return this.identityListLength;
    }

    public void setIdentityListLength(int identityListLength) {
        this.identityListLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.identityListLength, (Integer)identityListLength);
    }

    public void setIdentityListLength(ModifiableInteger identityListLength) {
        this.identityListLength = identityListLength;
    }

    public ModifiableInteger getBinderListLength() {
        return this.binderListLength;
    }

    public void setBinderListLength(int binderListLength) {
        this.binderListLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.binderListLength, (Integer)binderListLength);
    }

    public void setBinderListLength(ModifiableInteger binderListLength) {
        this.binderListLength = binderListLength;
    }

    public ModifiableInteger getSelectedIdentity() {
        return this.selectedIdentity;
    }

    public void setSelectedIdentity(ModifiableInteger selectedIdentity) {
        this.selectedIdentity = selectedIdentity;
    }

    public void setSelectedIdentity(int selectedIdentity) {
        this.selectedIdentity = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.selectedIdentity, (Integer)selectedIdentity);
    }

    public ModifiableByteArray getIdentityListBytes() {
        return this.identityListBytes;
    }

    public void setIdentityListBytes(ModifiableByteArray identityListBytes) {
        this.identityListBytes = identityListBytes;
    }

    public void setIdentityListBytes(byte[] identityListBytes) {
        this.identityListBytes = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.identityListBytes, (byte[])identityListBytes);
    }

    public ModifiableByteArray getBinderListBytes() {
        return this.binderListBytes;
    }

    public void setBinderListBytes(ModifiableByteArray binderListBytes) {
        this.binderListBytes = binderListBytes;
    }

    public void setBinderListBytes(byte[] binderListBytes) {
        this.binderListBytes = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.binderListBytes, (byte[])binderListBytes);
    }

    private void copyPskSets(List<PskSet> pskSets, boolean limitPsksToOne) {
        this.identities = new LinkedList<PSKIdentity>();
        this.binders = new LinkedList<PSKBinder>();
        int pskLimit = pskSets.size();
        if (limitPsksToOne) {
            pskLimit = 1;
        }
        for (int x = 0; x < pskLimit; ++x) {
            PSKIdentity pskIdentity = new PSKIdentity();
            pskIdentity.setIdentityConfig(pskSets.get(x).getPreSharedKeyIdentity());
            pskIdentity.setTicketAgeAddConfig(pskSets.get(x).getTicketAgeAdd());
            pskIdentity.setTicketAgeConfig(pskSets.get(x).getTicketAge());
            PSKBinder pskBinder = new PSKBinder();
            pskBinder.setBinderCipherConfig(pskSets.get(x).getCipherSuite());
            this.identities.add(pskIdentity);
            this.binders.add(pskBinder);
        }
    }

    public void getEntries(Chooser chooser) {
        if (chooser.getPskSets().size() > 0) {
            this.copyPskSets(chooser.getPskSets(), chooser.getConfig().isLimitPsksToOne());
        }
    }

    public List<ModifiableVariableHolder> getAllModifiableVariableHolders() {
        List allModifiableVariableHolders = super.getAllModifiableVariableHolders();
        if (this.binders != null) {
            allModifiableVariableHolders.addAll(this.binders);
        }
        if (this.identities != null) {
            allModifiableVariableHolders.addAll(this.binders);
        }
        return allModifiableVariableHolders;
    }

    @Override
    public PreSharedKeyExtensionParser getParser(Context context, InputStream stream) {
        return new PreSharedKeyExtensionParser(stream, context.getTlsContext());
    }

    @Override
    public PreSharedKeyExtensionPreparator getPreparator(Context context) {
        return new PreSharedKeyExtensionPreparator(context.getChooser(), this);
    }

    @Override
    public PreSharedKeyExtensionSerializer getSerializer(Context context) {
        return new PreSharedKeyExtensionSerializer(this, context.getChooser().getConnectionEndType());
    }

    @Override
    public PreSharedKeyExtensionHandler getHandler(Context context) {
        return new PreSharedKeyExtensionHandler(context.getTlsContext());
    }
}

