/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message.extension;

import de.rub.nds.modifiablevariable.HoldsModifiableVariable;
import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableHolder;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.integer.ModifiableInteger;
import de.rub.nds.tlsattacker.core.constants.ExtensionType;
import de.rub.nds.tlsattacker.core.protocol.handler.extension.ServerNameIndicationExtensionHandler;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.sni.ServerNamePair;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ServerNameIndicationExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.ServerNameIndicationExtensionPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.ServerNameIndicationExtensionSerializer;
import de.rub.nds.tlsattacker.core.state.Context;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;

@XmlRootElement(name="ServerNameIndicationExtension")
public class ServerNameIndicationExtensionMessage
extends ExtensionMessage {
    @ModifiableVariableProperty(purpose=ModifiableVariableProperty.Purpose.LENGTH)
    private ModifiableInteger serverNameListLength;
    @ModifiableVariableProperty
    private ModifiableByteArray serverNameListBytes;
    @HoldsModifiableVariable
    private List<ServerNamePair> serverNameList = new LinkedList<ServerNamePair>();

    public ServerNameIndicationExtensionMessage() {
        super(ExtensionType.SERVER_NAME_INDICATION);
    }

    public ModifiableInteger getServerNameListLength() {
        return this.serverNameListLength;
    }

    public void setServerNameListLength(ModifiableInteger serverNameListLength) {
        this.serverNameListLength = serverNameListLength;
    }

    public void setServerNameListLength(int length) {
        this.serverNameListLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.serverNameListLength, (Integer)length);
    }

    public ModifiableByteArray getServerNameListBytes() {
        return this.serverNameListBytes;
    }

    public void setServerNameListBytes(ModifiableByteArray serverNameListBytes) {
        this.serverNameListBytes = serverNameListBytes;
    }

    public void setServerNameListBytes(byte[] bytes) {
        this.serverNameListBytes = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.serverNameListBytes, (byte[])bytes);
    }

    public List<ServerNamePair> getServerNameList() {
        return this.serverNameList;
    }

    public void setServerNameList(List<ServerNamePair> serverNameList) {
        this.serverNameList = serverNameList;
    }

    public List<ModifiableVariableHolder> getAllModifiableVariableHolders() {
        List holders = super.getAllModifiableVariableHolders();
        return holders;
    }

    @Override
    public ServerNameIndicationExtensionParser getParser(Context context, InputStream stream) {
        return new ServerNameIndicationExtensionParser(stream, context.getTlsContext());
    }

    @Override
    public ServerNameIndicationExtensionPreparator getPreparator(Context context) {
        return new ServerNameIndicationExtensionPreparator(context.getChooser(), this);
    }

    @Override
    public ServerNameIndicationExtensionSerializer getSerializer(Context context) {
        return new ServerNameIndicationExtensionSerializer(this);
    }

    @Override
    public ServerNameIndicationExtensionHandler getHandler(Context context) {
        return new ServerNameIndicationExtensionHandler(context.getTlsContext());
    }
}

