/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message.extension.quic;

import de.rub.nds.modifiablevariable.HoldsModifiableVariable;
import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.integer.ModifiableInteger;
import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.protocol.util.SilentByteArrayOutputStream;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.ExtensionType;
import de.rub.nds.tlsattacker.core.protocol.handler.extension.ExtensionHandler;
import de.rub.nds.tlsattacker.core.protocol.handler.extension.quic.QuicTransportParametersExtensionsHandler;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.quic.QuicTransportParameterEntry;
import de.rub.nds.tlsattacker.core.protocol.message.extension.quic.QuicTransportParameters;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.quic.QuicTransportParametersExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.ExtensionPreparator;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.quic.QuicTransportParametersExtensionsPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.ExtensionSerializer;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.quic.QuicTransportParametersExtensionsSerializer;
import de.rub.nds.tlsattacker.core.state.Context;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bouncycastle.util.Arrays;

@XmlRootElement(name="QuicTransportParametersExtension")
public class QuicTransportParametersExtensionMessage
extends ExtensionMessage {
    @ModifiableVariableProperty
    private ModifiableInteger parameterExtensionsLength;
    @ModifiableVariableProperty
    private ModifiableByteArray parameterExtensions;
    @HoldsModifiableVariable
    private List<QuicTransportParameterEntry> transportParameterEntries = new ArrayList<QuicTransportParameterEntry>();
    private QuicTransportParameters quicTransportParameters;

    public QuicTransportParametersExtensionMessage() {
        super(ExtensionType.QUIC_TRANSPORT_PARAMETERS);
    }

    public QuicTransportParametersExtensionMessage(Config config) {
        super(ExtensionType.QUIC_TRANSPORT_PARAMETERS);
    }

    public ModifiableInteger getParameterExtensionsLength() {
        return this.parameterExtensionsLength;
    }

    public void setParameterExtensionsLength(ModifiableInteger parameterExtensionsLength) {
        this.parameterExtensionsLength = parameterExtensionsLength;
    }

    public void setParameterExtensionsLength(int parameterExtensionsLength) {
        this.parameterExtensionsLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.parameterExtensionsLength, (Integer)parameterExtensionsLength);
    }

    public ModifiableByteArray getParameterExtensions() {
        return this.parameterExtensions;
    }

    public void setParameterExtensions(ModifiableByteArray parameterExtensions) {
        this.parameterExtensions = parameterExtensions;
    }

    public void setParameterExtensions(byte[] parameterExtensions) {
        this.parameterExtensions = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.parameterExtensions, (byte[])parameterExtensions);
    }

    public List<QuicTransportParameterEntry> getTransportParameterEntries() {
        return this.transportParameterEntries;
    }

    public void setTransportParameterEntries(List<QuicTransportParameterEntry> transportParameterEntries) {
        this.transportParameterEntries = transportParameterEntries;
    }

    public QuicTransportParameters getQuicTransportParameters() {
        return this.quicTransportParameters;
    }

    public void setQuicTransportParameters(QuicTransportParameters quicTransportParameters) {
        this.quicTransportParameters = quicTransportParameters;
    }

    @Override
    public ExtensionHandler<QuicTransportParametersExtensionMessage> getHandler(Context context) {
        return new QuicTransportParametersExtensionsHandler(context.getTlsContext());
    }

    @Override
    public ExtensionSerializer<QuicTransportParametersExtensionMessage> getSerializer(Context context) {
        return new QuicTransportParametersExtensionsSerializer(this);
    }

    @Override
    public ExtensionPreparator<QuicTransportParametersExtensionMessage> getPreparator(Context context) {
        return new QuicTransportParametersExtensionsPreparator(context.getChooser(), this, (ExtensionSerializer<QuicTransportParametersExtensionMessage>)this.getSerializer(context));
    }

    @Override
    public ExtensionParser<QuicTransportParametersExtensionMessage> getParser(Context context, InputStream stream) {
        return new QuicTransportParametersExtensionParser(stream, context.getTlsContext());
    }

    @Override
    public String toString() {
        return "QuicTransportParametersExtensionMessage{\n" + this.transportParameterEntries.stream().map(QuicTransportParameterEntry::toString).collect(Collectors.joining(",\n")) + "\n}";
    }

    public static class PreferredAddress {
        private InetAddress ipv4Address;
        private int ipv4Port;
        private InetAddress ipv6Address;
        private int ipv6Port;
        private int connectionIdLength;
        private byte[] connectionId;
        private byte[] statelessResetToken;

        public PreferredAddress(byte[] entryValue) {
            try {
                this.ipv4Address = InetAddress.getByAddress(Arrays.copyOfRange((byte[])entryValue, (int)0, (int)4));
            }
            catch (UnknownHostException e) {
                this.ipv4Address = null;
            }
            this.ipv4Port = DataConverter.bytesToInt((byte[])Arrays.copyOfRange((byte[])entryValue, (int)4, (int)6));
            try {
                this.ipv6Address = InetAddress.getByAddress(Arrays.copyOfRange((byte[])entryValue, (int)6, (int)22));
            }
            catch (UnknownHostException e) {
                this.ipv6Address = null;
            }
            this.ipv6Port = DataConverter.bytesToInt((byte[])Arrays.copyOfRange((byte[])entryValue, (int)22, (int)24));
            this.connectionIdLength = DataConverter.bytesToInt((byte[])Arrays.copyOfRange((byte[])entryValue, (int)24, (int)25));
            this.connectionId = Arrays.copyOfRange((byte[])entryValue, (int)25, (int)(25 + this.connectionIdLength));
            this.statelessResetToken = Arrays.copyOfRange((byte[])entryValue, (int)(25 + this.connectionIdLength), (int)(25 + this.connectionIdLength + 16));
        }

        public String toString() {
            return "PreferredAddress{ipv4Address=" + String.valueOf(this.ipv4Address) + ", ipv4Port=" + this.ipv4Port + ", ipv6Address=" + String.valueOf(this.ipv6Address) + ", ipv6Port=" + this.ipv6Port + ", connectionId=" + DataConverter.bytesToHexString((byte[])this.connectionId) + ", statelessResetToken=" + DataConverter.bytesToHexString((byte[])this.statelessResetToken) + "}";
        }

        public byte[] serialize() throws IOException {
            SilentByteArrayOutputStream byteArrayOutputStream = new SilentByteArrayOutputStream();
            byteArrayOutputStream.write(this.ipv4Address.getAddress());
            byteArrayOutputStream.write(this.ipv4Port);
            byteArrayOutputStream.write(this.ipv6Address.getAddress());
            byteArrayOutputStream.write(this.ipv6Port);
            byteArrayOutputStream.write(this.connectionId.length);
            byteArrayOutputStream.write(this.connectionId);
            byteArrayOutputStream.write(this.statelessResetToken);
            return byteArrayOutputStream.toByteArray();
        }

        public InetAddress getIpv4Address() {
            return this.ipv4Address;
        }

        public void setIpv4Address(InetAddress ipv4Address) {
            this.ipv4Address = ipv4Address;
        }

        public int getIpv4Port() {
            return this.ipv4Port;
        }

        public void setIpv4Port(int ipv4Port) {
            this.ipv4Port = ipv4Port;
        }

        public InetAddress getIpv6Address() {
            return this.ipv6Address;
        }

        public void setIpv6Address(InetAddress ipv6Address) {
            this.ipv6Address = ipv6Address;
        }

        public int getIpv6Port() {
            return this.ipv6Port;
        }

        public void setIpv6Port(int ipv6Port) {
            this.ipv6Port = ipv6Port;
        }

        public int getConnectionIdLength() {
            return this.connectionIdLength;
        }

        public void setConnectionIdLength(int connectionIdLength) {
            this.connectionIdLength = connectionIdLength;
        }

        public byte[] getConnectionId() {
            return this.connectionId;
        }

        public void setConnectionId(byte[] connectionId) {
            this.connectionId = connectionId;
        }

        public byte[] getStatelessResetToken() {
            return this.statelessResetToken;
        }

        public void setStatelessResetToken(byte[] statelessResetToken) {
            this.statelessResetToken = statelessResetToken;
        }
    }
}

