/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser;

import de.rub.nds.tlsattacker.core.protocol.ProtocolMessageParser;
import de.rub.nds.tlsattacker.core.protocol.message.AlertMessage;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AlertParser
extends ProtocolMessageParser<AlertMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public AlertParser(InputStream stream) {
        super(stream);
    }

    @Override
    public void parse(AlertMessage message) {
        LOGGER.debug("Parsing AlertMessage");
        this.parseLevel(message);
        this.parseDescription(message);
        message.setCompleteResultingMessage(this.getAlreadyParsed());
    }

    private void parseLevel(AlertMessage msg) {
        msg.setLevel(this.parseByteField(1));
        LOGGER.debug("Level: {}", msg.getLevel().getValue());
    }

    private void parseDescription(AlertMessage msg) {
        msg.setDescription(this.parseByteField(1));
        LOGGER.debug("Description: {}", msg.getDescription().getValue());
    }
}

