/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser;

import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.message.CertificateRequestMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.HandshakeMessageParser;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CertificateRequestParser
extends HandshakeMessageParser<CertificateRequestMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public CertificateRequestParser(InputStream stream, TlsContext tlsContext) {
        super(stream, tlsContext);
    }

    @Override
    public void parse(CertificateRequestMessage msg) {
        LOGGER.debug("Parsing CertificateRequestMessage");
        if (this.getVersion().is13()) {
            this.parseCertificateRequestContextLength(msg);
            this.parseCertificateRequestContext(msg);
            this.parseExtensionLength(msg);
            this.parseExtensionBytes(msg, false);
        } else {
            this.parseClientCertificateTypesCount(msg);
            this.parseClientCertificateTypes(msg);
            if (this.getVersion() == ProtocolVersion.TLS12 || this.getVersion() == ProtocolVersion.DTLS12) {
                this.parseSignatureHashAlgorithmsLength(msg);
                this.parseSignatureHashAlgorithms(msg);
            }
            this.parseDistinguishedNamesLength(msg);
            if (this.hasDistinguishedNamesLength(msg)) {
                this.parseDistinguishedNames(msg);
            }
        }
    }

    private void parseClientCertificateTypesCount(CertificateRequestMessage msg) {
        msg.setClientCertificateTypesCount(this.parseIntField(1));
        LOGGER.debug("ClientCertificateTypesCount: {}", msg.getClientCertificateTypesCount().getValue());
    }

    private void parseClientCertificateTypes(CertificateRequestMessage msg) {
        msg.setClientCertificateTypes(this.parseByteArrayField((Integer)msg.getClientCertificateTypesCount().getValue()));
        LOGGER.debug("ClientCertificateTypes: {}", msg.getClientCertificateTypes().getValue());
    }

    private void parseSignatureHashAlgorithmsLength(CertificateRequestMessage msg) {
        msg.setSignatureHashAlgorithmsLength(this.parseIntField(2));
        LOGGER.debug("SignatureHashAlgorithmsLength: {}", msg.getSignatureHashAlgorithmsLength().getValue());
    }

    private void parseSignatureHashAlgorithms(CertificateRequestMessage msg) {
        msg.setSignatureHashAlgorithms(this.parseByteArrayField((Integer)msg.getSignatureHashAlgorithmsLength().getValue()));
        LOGGER.debug("SignatureHashAlgorithms: {}", msg.getSignatureHashAlgorithms().getValue());
    }

    private void parseDistinguishedNamesLength(CertificateRequestMessage msg) {
        msg.setDistinguishedNamesLength(this.parseIntField(2));
        LOGGER.debug("DistinguishedNamesLength: {}", msg.getDistinguishedNamesLength().getValue());
    }

    private boolean hasDistinguishedNamesLength(CertificateRequestMessage msg) {
        return (Integer)msg.getDistinguishedNamesLength().getValue() != 0;
    }

    private void parseDistinguishedNames(CertificateRequestMessage msg) {
        msg.setDistinguishedNames(this.parseByteArrayField((Integer)msg.getDistinguishedNamesLength().getValue()));
        LOGGER.debug("DistinguishedNames: {}", msg.getDistinguishedNames().getValue());
    }

    private void parseCertificateRequestContextLength(CertificateRequestMessage msg) {
        msg.setCertificateRequestContextLength(this.parseIntField(1));
        LOGGER.debug("CertificateRequestContextLength: {}", msg.getCertificateRequestContextLength().getValue());
    }

    private void parseCertificateRequestContext(CertificateRequestMessage msg) {
        msg.setCertificateRequestContext(this.parseByteArrayField((Integer)msg.getCertificateRequestContextLength().getValue()));
        LOGGER.debug("CertificateRequestContext: {}", msg.getCertificateRequestContext().getValue());
    }
}

