/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser;

import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.message.CertificateVerifyMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.HandshakeMessageParser;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CertificateVerifyParser
extends HandshakeMessageParser<CertificateVerifyMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public CertificateVerifyParser(InputStream stream, TlsContext tlsContext) {
        super(stream, tlsContext);
    }

    @Override
    public void parse(CertificateVerifyMessage msg) {
        LOGGER.debug("Parsing CertificateVerifyMessage");
        if (this.getVersion() == ProtocolVersion.TLS12 || this.getVersion() == ProtocolVersion.DTLS12 || this.getVersion().is13()) {
            this.parseSignatureHashAlgorithm(msg);
        }
        this.parseSignatureLength(msg);
        this.parseSignature(msg);
    }

    private void parseSignatureHashAlgorithm(CertificateVerifyMessage msg) {
        msg.setSignatureHashAlgorithm(this.parseByteArrayField(2));
        LOGGER.debug("SignatureHashAlgorithm: {}", msg.getSignatureHashAlgorithm().getValue());
    }

    private void parseSignatureLength(CertificateVerifyMessage msg) {
        msg.setSignatureLength(this.parseIntField(2));
        LOGGER.debug("SignatureLength: {}", msg.getSignatureLength().getValue());
    }

    private void parseSignature(CertificateVerifyMessage msg) {
        msg.setSignature(this.parseByteArrayField((Integer)msg.getSignatureLength().getValue()));
        LOGGER.debug("signature: {}", msg.getSignature().getValue());
    }
}

