/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser;

import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.message.ECDHClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.ClientKeyExchangeParser;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ECDHClientKeyExchangeParser<T extends ECDHClientKeyExchangeMessage>
extends ClientKeyExchangeParser<T> {
    private static final Logger LOGGER = LogManager.getLogger();

    public ECDHClientKeyExchangeParser(InputStream stream, TlsContext tlsContext) {
        super(stream, tlsContext);
    }

    @Override
    public void parse(T msg) {
        LOGGER.debug("Parsing ECDHClientKeyExchangeMessage");
        this.parseSerializedPublicKeyLength((ECDHClientKeyExchangeMessage)msg);
        this.parseSerializedPublicKey((ECDHClientKeyExchangeMessage)msg);
    }

    protected void parseEcDhParams(T msg) {
        this.parseSerializedPublicKeyLength((ECDHClientKeyExchangeMessage)msg);
        this.parseSerializedPublicKey((ECDHClientKeyExchangeMessage)msg);
    }

    private void parseSerializedPublicKeyLength(ECDHClientKeyExchangeMessage msg) {
        msg.setPublicKeyLength(this.parseIntField(1));
        LOGGER.debug("SerializedPublicKeyLength: {}", msg.getPublicKeyLength().getValue());
    }

    private void parseSerializedPublicKey(ECDHClientKeyExchangeMessage msg) {
        msg.setPublicKey(this.parseByteArrayField((Integer)msg.getPublicKeyLength().getValue()));
        LOGGER.debug("SerializedPublicKey: {}", msg.getPublicKey().getValue());
    }
}

