/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser;

import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.message.ECDHEServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.ServerKeyExchangeParser;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ECDHEServerKeyExchangeParser<T extends ECDHEServerKeyExchangeMessage>
extends ServerKeyExchangeParser<T> {
    private static final Logger LOGGER = LogManager.getLogger();

    public ECDHEServerKeyExchangeParser(InputStream stream, TlsContext tlsContext) {
        super(stream, tlsContext);
    }

    @Override
    public void parse(ECDHEServerKeyExchangeMessage msg) {
        LOGGER.debug("Parsing ECDHEServerKeyExchangeMessage");
        this.parseCurveType(msg);
        this.parseNamedGroup(msg);
        this.parseSerializedPublicKeyLength(msg);
        this.parseSerializedPublicKey(msg);
        if (this.shouldParseSignature()) {
            if (this.isTLS12() || this.isDTLS12()) {
                this.parseSignatureAndHashAlgorithm(msg);
            }
            this.parseSignatureLength(msg);
            this.parseSignature(msg);
        }
    }

    protected void parseEcDheParams(T msg) {
        this.parseCurveType((ECDHEServerKeyExchangeMessage)msg);
        this.parseNamedGroup((ECDHEServerKeyExchangeMessage)msg);
        this.parseSerializedPublicKeyLength((ECDHEServerKeyExchangeMessage)msg);
        this.parseSerializedPublicKey((ECDHEServerKeyExchangeMessage)msg);
    }

    private void parseCurveType(ECDHEServerKeyExchangeMessage msg) {
        msg.setCurveType(this.parseByteField(1));
        LOGGER.debug("CurveType: {}", msg.getGroupType().getValue());
    }

    private void parseNamedGroup(ECDHEServerKeyExchangeMessage msg) {
        msg.setNamedGroup(this.parseByteArrayField(2));
        LOGGER.debug("NamedGroup: {}", msg.getNamedGroup().getValue());
    }

    private void parseSerializedPublicKeyLength(ECDHEServerKeyExchangeMessage msg) {
        msg.setPublicKeyLength(this.parseIntField(1));
        LOGGER.debug("SerializedPublicKeyLength: {}", msg.getPublicKeyLength().getValue());
    }

    private void parseSerializedPublicKey(ECDHEServerKeyExchangeMessage msg) {
        msg.setPublicKey(this.parseByteArrayField((Integer)msg.getPublicKeyLength().getValue()));
        LOGGER.debug("SerializedPublicKey: {}", msg.getPublicKey().getValue());
    }

    private void parseSignatureAndHashAlgorithm(ECDHEServerKeyExchangeMessage msg) {
        msg.setSignatureAndHashAlgorithm(this.parseByteArrayField(2));
        LOGGER.debug("SignatureAndHashAlgorithm: {}", msg.getSignatureAndHashAlgorithm().getValue());
    }

    private void parseSignatureLength(ECDHEServerKeyExchangeMessage msg) {
        msg.setSignatureLength(this.parseIntField(2));
        LOGGER.debug("SignatureLength: {}", msg.getSignatureLength().getValue());
    }

    private void parseSignature(ECDHEServerKeyExchangeMessage msg) {
        msg.setSignature(this.parseByteArrayField((Integer)msg.getSignatureLength().getValue()));
        LOGGER.debug("Signature: {}", msg.getSignature().getValue());
    }
}

