/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser;

import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.ProtocolMessageParser;
import de.rub.nds.tlsattacker.core.protocol.message.HandshakeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ExtensionListParser;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class HandshakeMessageParser<T extends HandshakeMessage>
extends ProtocolMessageParser<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    private ProtocolVersion version;
    private TlsContext tlsContext;

    public HandshakeMessageParser(InputStream stream, ProtocolVersion version, TlsContext tlsContext) {
        super(stream);
        this.version = version;
        this.tlsContext = tlsContext;
    }

    public HandshakeMessageParser(InputStream stream, TlsContext tlsContext) {
        this(stream, tlsContext.getSelectedProtocolVersion() != null ? tlsContext.getSelectedProtocolVersion() : tlsContext.getChooser().getLastRecordVersion(), tlsContext);
    }

    protected void parseExtensionLength(T message) {
        ((HandshakeMessage)message).setExtensionsLength(this.parseIntField(2));
        LOGGER.debug("ExtensionLength: {}", ((HandshakeMessage)message).getExtensionsLength().getValue());
    }

    protected void parseExtensionBytes(T message, boolean helloRetryRequestHint) {
        byte[] extensionBytes = this.parseByteArrayField((Integer)((HandshakeMessage)message).getExtensionsLength().getValue());
        ((HandshakeMessage)message).setExtensionBytes(extensionBytes);
        LOGGER.debug("ExtensionBytes:{}", (Object)extensionBytes);
        ByteArrayInputStream innerStream = new ByteArrayInputStream(extensionBytes);
        ExtensionListParser parser = new ExtensionListParser(innerStream, this.tlsContext, helloRetryRequestHint);
        LinkedList<ExtensionMessage> extensionMessages = new LinkedList<ExtensionMessage>();
        parser.parse((List<ExtensionMessage>)extensionMessages);
        ((HandshakeMessage)message).setExtensions(extensionMessages);
    }

    protected boolean hasExtensionLengthField() {
        return this.getBytesLeft() > 0;
    }

    protected boolean hasExtensions(T message) {
        return (Integer)((HandshakeMessage)message).getExtensionsLength().getValue() > 0;
    }

    protected ProtocolVersion getVersion() {
        return this.version;
    }

    protected void setVersion(ProtocolVersion version) {
        this.version = version;
    }
}

