/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser;

import de.rub.nds.tlsattacker.core.protocol.ProtocolMessageParser;
import de.rub.nds.tlsattacker.core.protocol.message.HeartbeatMessage;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HeartbeatMessageParser
extends ProtocolMessageParser<HeartbeatMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public HeartbeatMessageParser(InputStream stream) {
        super(stream);
    }

    @Override
    public void parse(HeartbeatMessage message) {
        LOGGER.debug("Parsing HeartbeatMessage");
        this.parseHeartbeatMessageType(message);
        this.parsePayloadLength(message);
        this.parsePayload(message);
        this.parsePadding(message);
        message.setCompleteResultingMessage(this.getAlreadyParsed());
    }

    private void parseHeartbeatMessageType(HeartbeatMessage msg) {
        msg.setHeartbeatMessageType(this.parseByteField(1));
        LOGGER.debug("HeartbeatMessageType: {}", msg.getHeartbeatMessageType().getValue());
    }

    private void parsePayloadLength(HeartbeatMessage msg) {
        msg.setPayloadLength(this.parseIntField(2));
        LOGGER.debug("PayloadLength: {}", msg.getPayloadLength().getValue());
    }

    private void parsePayload(HeartbeatMessage msg) {
        msg.setPayload(this.parseByteArrayField((Integer)msg.getPayloadLength().getValue()));
        LOGGER.debug("Payload: {}", msg.getPayload().getValue());
    }

    private void parsePadding(HeartbeatMessage msg) {
        msg.setPadding(this.parseByteArrayField(this.getBytesLeft()));
        LOGGER.debug("Padding: {}", msg.getPadding().getValue());
    }
}

