/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser;

import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.message.HelloVerifyRequestMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.HandshakeMessageParser;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HelloVerifyRequestParser
extends HandshakeMessageParser<HelloVerifyRequestMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public HelloVerifyRequestParser(InputStream inputStream, TlsContext tlsContext) {
        super(inputStream, tlsContext);
    }

    @Override
    public void parse(HelloVerifyRequestMessage msg) {
        LOGGER.debug("Parsing HelloVerifyRequestMessage");
        this.parseProtocolVersion(msg);
        this.parseCookieLength(msg);
        this.parseCookie(msg);
    }

    private void parseProtocolVersion(HelloVerifyRequestMessage msg) {
        msg.setProtocolVersion(this.parseByteArrayField(2));
        LOGGER.debug("ProtocolVersion: {}", msg.getProtocolVersion().getValue());
    }

    private void parseCookieLength(HelloVerifyRequestMessage msg) {
        msg.setCookieLength(this.parseByteField(1));
        LOGGER.debug("CookieLength: {}", msg.getCookieLength().getValue());
    }

    private void parseCookie(HelloVerifyRequestMessage msg) {
        msg.setCookie(this.parseByteArrayField(((Byte)msg.getCookieLength().getValue()).byteValue()));
        LOGGER.debug("Cookie: {}", msg.getCookie().getValue());
    }
}

