/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser;

import de.rub.nds.tlsattacker.core.constants.ConnectionIdUsage;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.message.NewConnectionIdMessage;
import de.rub.nds.tlsattacker.core.protocol.message.connectionid.ConnectionId;
import de.rub.nds.tlsattacker.core.protocol.parser.HandshakeMessageParser;
import java.io.InputStream;
import java.util.LinkedList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NewConnectionIdParser
extends HandshakeMessageParser<NewConnectionIdMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public NewConnectionIdParser(InputStream stream, TlsContext tlsContext) {
        super(stream, tlsContext);
    }

    @Override
    public void parse(NewConnectionIdMessage message) {
        LOGGER.debug("Parsing NewConnectionIdMessage");
        this.parseConnectionIdsLength(message);
        this.parseConnectionIds(message);
        this.parseUsage(message);
    }

    private void parseUsage(NewConnectionIdMessage message) {
        message.setUsage(ConnectionIdUsage.getConnectionIdUsage(this.parseByteField(1)));
        LOGGER.debug("Usage: {}", (Object)message.getUsage());
    }

    private void parseConnectionIds(NewConnectionIdMessage message) {
        ConnectionId cid;
        LOGGER.debug("ConnectionIds: ");
        message.setConnectionIds(new LinkedList<ConnectionId>());
        for (int i = 0; i < (Integer)message.getConnectionIdsLength().getValue(); i += ((Integer)cid.getLength().getValue()).intValue()) {
            cid = new ConnectionId();
            cid.setLength(this.parseIntField(1));
            cid.setConnectionId(this.parseByteArrayField((Integer)cid.getLength().getValue()));
            message.getConnectionIds().add(cid);
            LOGGER.debug("\t - {}", cid.getConnectionId().getValue());
        }
    }

    private void parseConnectionIdsLength(NewConnectionIdMessage message) {
        message.setConnectionIdsLength(this.parseIntField(2));
        LOGGER.debug("ConnectionIdsLength: {}", message.getConnectionIdsLength().getValue());
    }
}

