/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser;

import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.message.NewSessionTicketMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.HandshakeMessageParser;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NewSessionTicketParser
extends HandshakeMessageParser<NewSessionTicketMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public NewSessionTicketParser(InputStream stream, TlsContext tlsContext) {
        super(stream, tlsContext);
    }

    @Override
    public void parse(NewSessionTicketMessage msg) {
        LOGGER.debug("Parsing NewSessionTicket");
        if (this.getVersion().is13()) {
            this.parseLifetime(msg);
            this.parseAgeAdd(msg);
            this.parseNonceLength(msg);
            this.parseNonce(msg);
            this.parseIdentityLength(msg);
            this.parseIdentity(msg);
            if (this.hasExtensionLengthField()) {
                this.parseExtensionLength(msg);
                if (this.hasExtensions(msg)) {
                    this.parseExtensionBytes(msg, false);
                }
            }
        } else {
            this.parseLifetime(msg);
            this.parseIdentityLength(msg);
            this.parseIdentity(msg);
        }
    }

    private void parseLifetime(NewSessionTicketMessage msg) {
        msg.setTicketLifetimeHint(this.parseIntField(4));
        LOGGER.debug("TicketLifetimeHint: {}", msg.getTicketLifetimeHint().getValue());
    }

    private void parseAgeAdd(NewSessionTicketMessage msg) {
        msg.getTicket().setTicketAgeAdd(this.parseByteArrayField(4));
        LOGGER.debug("TicketAgeAdd: {}", msg.getTicket().getTicketAgeAdd().getValue());
    }

    private void parseNonceLength(NewSessionTicketMessage msg) {
        msg.getTicket().setTicketNonceLength(this.parseIntField(1));
        LOGGER.debug("TicketNonceLength: {}", msg.getTicket().getTicketNonceLength().getValue());
    }

    private void parseNonce(NewSessionTicketMessage msg) {
        msg.getTicket().setTicketNonce(this.parseByteArrayField((Integer)msg.getTicket().getTicketNonceLength().getValue()));
        LOGGER.debug("TicketNonce: {}", msg.getTicket().getTicketNonce().getValue());
    }

    private void parseIdentityLength(NewSessionTicketMessage msg) {
        msg.getTicket().setIdentityLength(this.parseIntField(2));
        LOGGER.debug("IdentityLength: {}", msg.getTicket().getIdentityLength().getValue());
    }

    private void parseIdentity(NewSessionTicketMessage msg) {
        msg.getTicket().setIdentity(this.parseByteArrayField((Integer)msg.getTicket().getIdentityLength().getValue()));
        LOGGER.debug("Identity: {}", msg.getTicket().getIdentity().getValue());
    }
}

