/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser;

import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.message.PWDClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.ClientKeyExchangeParser;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PWDClientKeyExchangeParser
extends ClientKeyExchangeParser<PWDClientKeyExchangeMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public PWDClientKeyExchangeParser(InputStream stream, TlsContext tlsContext) {
        super(stream, tlsContext);
    }

    @Override
    public void parse(PWDClientKeyExchangeMessage msg) {
        LOGGER.debug("Parsing PWDClientKeyExchangeMessage");
        this.parseElementLength(msg);
        this.parseElement(msg);
        this.parseScalarLength(msg);
        this.parseScalar(msg);
    }

    private void parseElementLength(PWDClientKeyExchangeMessage msg) {
        msg.setElementLength(this.parseIntField(1));
        LOGGER.debug("ElementLength: {}", msg.getElementLength().getValue());
    }

    private void parseElement(PWDClientKeyExchangeMessage msg) {
        msg.setElement(this.parseByteArrayField((Integer)msg.getElementLength().getValue()));
        LOGGER.debug("Element: {}", msg.getElement().getValue());
    }

    private void parseScalarLength(PWDClientKeyExchangeMessage msg) {
        msg.setScalarLength(this.parseIntField(1));
        LOGGER.debug("ScalarLength: {}", msg.getScalarLength().getValue());
    }

    private void parseScalar(PWDClientKeyExchangeMessage msg) {
        msg.setScalar(this.parseByteArrayField((Integer)msg.getScalarLength().getValue()));
        LOGGER.debug("Scalar: {}", msg.getScalar().getValue());
    }
}

