/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser;

import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.message.PskEcDheServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.ECDHEServerKeyExchangeParser;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PskEcDheServerKeyExchangeParser
extends ECDHEServerKeyExchangeParser<PskEcDheServerKeyExchangeMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public PskEcDheServerKeyExchangeParser(InputStream stream, TlsContext tlsContext) {
        super(stream, tlsContext);
    }

    @Override
    public void parse(PskEcDheServerKeyExchangeMessage msg) {
        LOGGER.debug("Parsing PSKECDHEServerKeyExchangeMessage");
        this.parsePskIdentityHintLength(msg);
        this.parsePskIdentityHint(msg);
        super.parseEcDheParams(msg);
    }

    private void parsePskIdentityHintLength(PskEcDheServerKeyExchangeMessage msg) {
        msg.setIdentityHintLength(this.parseIntField(2));
        LOGGER.debug("SerializedPSK-IdentityLength: {}", msg.getIdentityHintLength().getValue());
    }

    private void parsePskIdentityHint(PskEcDheServerKeyExchangeMessage msg) {
        msg.setIdentityHint(this.parseByteArrayField((Integer)msg.getIdentityHintLength().getValue()));
        LOGGER.debug("SerializedPSK-Identity: {}", msg.getIdentityHint().getValue());
    }
}

