/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser;

import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.message.PskServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.ServerKeyExchangeParser;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PskServerKeyExchangeParser
extends ServerKeyExchangeParser<PskServerKeyExchangeMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public PskServerKeyExchangeParser(InputStream stream, TlsContext tlsContext) {
        super(stream, tlsContext);
    }

    @Override
    public void parse(PskServerKeyExchangeMessage msg) {
        LOGGER.debug("Parsing PSKECDHEServerKeyExchangeMessage");
        this.parsePskIdentityHintLength(msg);
        this.parsePskIdentityHint(msg);
    }

    private void parsePskIdentityHintLength(PskServerKeyExchangeMessage msg) {
        msg.setIdentityHintLength(this.parseIntField(2));
        LOGGER.debug("SerializedPSK-IdentityLength: {}", msg.getIdentityHintLength().getValue());
    }

    private void parsePskIdentityHint(PskServerKeyExchangeMessage msg) {
        msg.setIdentityHint(this.parseByteArrayField((Integer)msg.getIdentityHintLength().getValue()));
        LOGGER.debug("SerializedPSK-Identity: {}", msg.getIdentityHint().getValue());
    }
}

